/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.resouces;

import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import ru.vizzi.Utils.resouces.IResourceLoader;
import ru.vizzi.Utils.resouces.PNGTextureLoader;
import ru.vizzi.Utils.resouces.ZipResourceLoader;

public class CoreAPI {
    public static boolean isDefaultScale = true;
    private static final List<IResourceLoader> resourceLoaderList = Collections.synchronizedList(new ArrayList());
    private static boolean isInitialized;

    public static void init() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        CoreAPI.registerResourceLoader(new ZipResourceLoader());
    }

    private static byte[] readArray(DataInputStream dataInputStream, int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = dataInputStream.readByte();
        }
        return bytes;
    }

    public static void registerResourceLoader(IResourceLoader resourceLoader) {
        resourceLoaderList.add(resourceLoader);
    }

    public static List<IResourceLoader> getResourceLoaders() {
        return resourceLoaderList;
    }

    public static InputStream getInputStreamFromZip(ResourceLocation loc) {
        return CoreAPI.getResourceInputStream(loc.func_110624_b() + "/" + loc.func_110623_a());
    }

    public static InputStream getResourceInputStream(String loc) {
        try {
            for (IResourceLoader resourceLoader : CoreAPI.getResourceLoaders()) {
                InputStream inputStream = resourceLoader.getResourceInputStream(loc);
                if (inputStream == null) continue;
                return inputStream;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        throw new RuntimeException("An error has occurred during loading resource " + loc);
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        CoreAPI.bindTexture(resourceLocation, true);
    }

    public static void bindTexture(ResourceLocation resourceLocation, boolean decryptBefore) {
        CoreAPI.bindTexture(resourceLocation, decryptBefore, 33069);
    }

    public static void bindTexture(final ResourceLocation loc, boolean decryptBefore, final int wrapFormat) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (textureManager.func_110581_b(loc) == null) {
            textureManager.func_110579_a(loc, (ITextureObject)new AbstractTexture(){

                public void func_110551_a(IResourceManager p_110551_1_) throws IOException {
                    this.func_147631_c();
                    InputStream inputStream = CoreAPI.getResourceInputStream(loc.func_110624_b() + "/" + loc.func_110623_a());
                    if (inputStream != null) {
                        BufferedImage bufferedimage = ImageIO.read(inputStream);
                        PNGTextureLoader.loadTexture((ITextureObject)this, PNGTextureLoader.loadImageData(bufferedimage, wrapFormat));
                        inputStream.close();
                    }
                }
            });
        }
        textureManager.func_110577_a(loc);
    }
}

