/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.resouces;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import org.lwjgl.opengl.GL11;

public class PNGTextureLoader {
    private static final ColorModel glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    private static final ColorModel glColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);

    public static void loadTexture(ITextureObject textureObject, ImageSimpleData imageSimpleData) {
        int srcInternalFormat;
        int srcPixelFormat;
        GL11.glDeleteTextures((int)textureObject.func_110552_b());
        GL11.glBindTexture((int)3553, (int)textureObject.func_110552_b());
        if (imageSimpleData.hasAlpha) {
            srcPixelFormat = 6408;
            srcInternalFormat = 6408;
        } else {
            srcPixelFormat = 6407;
            srcInternalFormat = 6407;
        }
        GL11.glTexImage2D((int)3553, (int)0, (int)srcInternalFormat, (int)imageSimpleData.getWidth(), (int)imageSimpleData.getHeight(), (int)0, (int)srcPixelFormat, (int)5121, (ByteBuffer)imageSimpleData.byteBuffer);
        if (OpenGlHelper.field_148825_d) {
            GL11.glTexParameterf((int)3553, (int)34046, (float)Minecraft.func_71410_x().field_71474_y.field_151443_J);
        }
        int wrapFormat = imageSimpleData.getWrapFormat();
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrapFormat);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrapFormat);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        imageSimpleData.byteBuffer.clear();
    }

    private static ByteBuffer loadImageData0(BufferedImage bufferedImage) {
        BufferedImage texImage;
        int texWidth = bufferedImage.getWidth();
        int texHeight = bufferedImage.getHeight();
        boolean hasAlpha = bufferedImage.getColorModel().hasAlpha();
        if (hasAlpha) {
            WritableRaster raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 4, null);
            texImage = new BufferedImage(glAlphaColorModel, raster, false, new Hashtable());
        } else {
            WritableRaster raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 3, null);
            texImage = new BufferedImage(glColorModel, raster, false, new Hashtable());
        }
        Graphics g = texImage.getGraphics();
        g.setColor(hasAlpha ? new Color(0.0f, 0.0f, 0.0f, 0.0f) : new Color(0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, texWidth, texHeight);
        g.drawImage(bufferedImage, 0, 0, null);
        byte[] data = ((DataBufferByte)texImage.getRaster().getDataBuffer()).getData();
        ByteBuffer imageBuffer = ByteBuffer.allocateDirect(data.length);
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(data, 0, data.length);
        imageBuffer.flip();
        return imageBuffer;
    }

    public static ImageSimpleData loadImageData(BufferedImage bufferedImage, int wrapFormat) {
        return new ImageSimpleData(PNGTextureLoader.loadImageData0(bufferedImage), bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getColorModel().hasAlpha(), wrapFormat);
    }

    public static class ImageSimpleData {
        private final ByteBuffer byteBuffer;
        private final int width;
        private final int height;
        private final boolean hasAlpha;
        private final int wrapFormat;

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isHasAlpha() {
            return this.hasAlpha;
        }

        public int getWrapFormat() {
            return this.wrapFormat;
        }

        public ImageSimpleData(ByteBuffer byteBuffer, int width, int height, boolean hasAlpha, int wrapFormat) {
            this.byteBuffer = byteBuffer;
            this.width = width;
            this.height = height;
            this.hasAlpha = hasAlpha;
            this.wrapFormat = wrapFormat;
        }
    }
}

