/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.resouces;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.util.ResourceLocation;
import ru.vizzi.Utils.EventLoadResource;
import ru.vizzi.Utils.eventhandler.RegistryEvent;
import ru.vizzi.Utils.resouces.PreLoadableResourceScanner;
import ru.vizzi.Utils.resouces.ResourceType;

@RegistryEvent
public class PreLoadableResourceManager {
    private final ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newFixedThreadPool(3);
    private final Queue<FutureTask<Object>> asyncQueue = new LinkedList<FutureTask<Object>>();
    private final Queue<FutureTask<Object>> syncQueue = new LinkedList<FutureTask<Object>>();
    private final PreLoadableResourceScanner preLoadableResourceScanner = new PreLoadableResourceScanner();

    public void loadAll() {
        this.processFields(this.preLoadableResourceScanner.scanFields());
        for (Class<?> clazz : this.preLoadableResourceScanner.scanClasses()) {
            Field[] fields = clazz.getFields();
            this.processFields(Arrays.asList(fields));
        }
        int totalTasks = this.asyncQueue.size();
        while (!this.asyncQueue.isEmpty()) {
            FutureTask<Object> poll = this.asyncQueue.poll();
            if (poll != null) {
                this.executorService.submit(poll);
                continue;
            }
            if (this.asyncQueue.remove(null)) continue;
            this.asyncQueue.clear();
        }
        while (this.executorService.getCompletedTaskCount() != (long)totalTasks) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        while (!this.syncQueue.isEmpty()) {
            this.syncQueue.poll().run();
        }
        this.executorService.shutdown();
    }

    private void processFields(Collection<Field> fields) {
        block4: for (Field field : fields) {
            ResourceLocation resourceLocation;
            if (field.getType() != ResourceLocation.class || !Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || (resourceLocation = (ResourceLocation)field.get(null)) == null) continue;
            for (ResourceType value : ResourceType.values()) {
                if (!resourceLocation.func_110623_a().endsWith(value.getFormatString())) continue;
                try {
                    this.asyncQueue.add(new FutureTask<Object>(() -> {
                        Object apply = value.getAsyncFunction().apply(field, resourceLocation);
                        Queue<FutureTask<Object>> queue = this.syncQueue;
                        synchronized (queue) {
                            this.syncQueue.add(new FutureTask<Object>(() -> value.getSyncConsumer().accept(resourceLocation, apply), null));
                        }
                    }, null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue block4;
            }
        }
    }

    @SubscribeEvent
    public void event(EventLoadResource event) {
        this.loadAll();
    }
}

