/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.resouces;

import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.util.ResourceLocation;
import ru.vizzi.Utils.resouces.PNGTextureLoader;
import ru.vizzi.Utils.resouces.PreLoadableTextureWrapFormat;
import ru.vizzi.Utils.resouces.TextureLoader;

public enum ResourceType {
    PNG("png", (field, resourceLocation) -> {
        int wrapFormat = 33069;
        PreLoadableTextureWrapFormat annotation = field.getAnnotation(PreLoadableTextureWrapFormat.class);
        if (annotation != null) {
            wrapFormat = annotation.value();
        }
        return TextureLoader.preloadTexture(resourceLocation, wrapFormat);
    }, (resourceLocation, o) -> TextureLoader.loadTexture(resourceLocation, (PNGTextureLoader.ImageSimpleData)o));

    private final String formatString;
    private final BiFunction<Field, ResourceLocation, Object> asyncFunction;
    private final BiConsumer<ResourceLocation, Object> syncConsumer;

    public String getFormatString() {
        return this.formatString;
    }

    public BiFunction<Field, ResourceLocation, Object> getAsyncFunction() {
        return this.asyncFunction;
    }

    public BiConsumer<ResourceLocation, Object> getSyncConsumer() {
        return this.syncConsumer;
    }

    private ResourceType(String formatString, BiFunction<Field, ResourceLocation, Object> asyncFunction, BiConsumer<ResourceLocation, Object> syncConsumer) {
        this.formatString = formatString;
        this.asyncFunction = asyncFunction;
        this.syncConsumer = syncConsumer;
    }
}

