/*
 * Decompiled with CFR 0.152.
 */
package ru.vizzi.Utils.resouces;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import ru.vizzi.Utils.CompletableFutureBuilder;
import ru.vizzi.Utils.resouces.CoreAPI;
import ru.vizzi.Utils.resouces.DynamicTextureNew;
import ru.vizzi.Utils.resouces.PNGTextureLoader;
import ru.vizzi.Utils.resouces.SimpleTextureData;
import ru.vizzi.Utils.resouces.Texture;

public class TextureLoader {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(1);

    public CompletableFuture<BufferedImage> preloadTextureAsync(InputStream inputStream) {
        return this.preloadTextureAsync(inputStream, "png");
    }

    public CompletableFuture<BufferedImage> preloadTextureAsync(InputStream inputStream, String imageFormat) {
        return CompletableFuture.supplyAsync(() -> this.preloadTexture(inputStream, imageFormat), EXECUTOR_SERVICE);
    }

    public BufferedImage preloadTexture(InputStream inputStream) {
        return this.preloadTexture(inputStream, "png");
    }

    public BufferedImage preloadTexture(InputStream inputStream, String imageFormat) {
        boolean isJPG = imageFormat.equalsIgnoreCase("jpg");
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (isJPG) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            if (ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOut)) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOut.toByteArray());
                bufferedImage = ImageIO.read(byteArrayInputStream);
                byteArrayInputStream.close();
            } else {
                bufferedImage = null;
            }
            byteArrayOut.close();
        }
        return bufferedImage;
    }

    public SimpleTextureData preloadTexture(ResourceLocation resourceLocation) {
        return this.readTexture(this.preloadTexture(CoreAPI.getInputStreamFromZip(resourceLocation), "png"));
    }

    public void loadTexture(ResourceLocation resourceLocation, SimpleTextureData simpleTextureData) {
        if (Minecraft.func_71410_x().func_110434_K().func_110581_b(resourceLocation) != null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)new DynamicTextureNew(simpleTextureData.getPixels(), simpleTextureData.getWidth(), simpleTextureData.getHeight()));
    }

    public int[] readPixels(BufferedImage bufferedImage) {
        return bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), new int[bufferedImage.getWidth() * bufferedImage.getHeight() * 3], 0, bufferedImage.getWidth());
    }

    public SimpleTextureData readTexture(BufferedImage bufferedImage) {
        return new SimpleTextureData(this.readPixels(bufferedImage), bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public ResourceLocation loadTexture(int[] pixels, int width, int height, String path) {
        ResourceLocation resourceLocation = new ResourceLocation(path);
        if (Minecraft.func_71410_x().func_110434_K().func_110581_b(resourceLocation) != null) {
            return resourceLocation;
        }
        System.out.println("widht:" + width);
        System.out.println("height:" + height);
        System.out.println("pixels:" + pixels.toString());
        Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)new DynamicTextureNew(pixels, width, height));
        return resourceLocation;
    }

    public CompletableFutureBuilder<ResourceLocation> loadTexture(InputStream inputStream, String imageFormat, String path) {
        return CompletableFutureBuilder.supplyAsync(() -> this.preloadTexture(inputStream, imageFormat), EXECUTOR_SERVICE).syncQueueTimeout(-1L).thenApply(bufferedImage -> {
            try {
                return this.readTexture((BufferedImage)bufferedImage);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }).thenApplySync(simpleTextureData -> {
            try {
                return this.loadTexture(simpleTextureData.getPixels(), simpleTextureData.getWidth(), simpleTextureData.getHeight(), path);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        });
    }

    public static PNGTextureLoader.ImageSimpleData preloadTexture(ResourceLocation resourceLocation, int wrapFormat) {
        return PNGTextureLoader.loadImageData(ImageIO.read(CoreAPI.getInputStreamFromZip(resourceLocation)), wrapFormat);
    }

    public static void loadTexture(ResourceLocation resourceLocation, PNGTextureLoader.ImageSimpleData imageSimpleData) {
        Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)new Texture(imageSimpleData));
    }
}

