/*
 * Decompiled with CFR 0.152.
 */
package su.luckycraft.recipemaker.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import su.luckycraft.recipemaker.common.LuckyRecipeMaker;
import su.luckycraft.recipemaker.common.network.MessageSaveNBTToBook;

@SideOnly(value=Side.CLIENT)
public class GuiMagicBook
extends GuiScreen {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private final boolean bookIsUnsigned;
    private boolean field_146481_r;
    private boolean field_146480_s;
    private ItemStack bookObj;
    private int updateCount;
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private int bookTotalPages = 1;
    private int currPage;
    private NBTTagList bookPages;
    private String bookTitle = "";
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GuiButton buttonDone;
    private static final String __OBFID = "CL_00000744";

    public GuiMagicBook(boolean isWrite, ItemStack book) {
        this.bookIsUnsigned = isWrite;
        this.bookObj = book;
        if (this.bookObj.func_77942_o()) {
            NBTTagCompound nbttagcompound = this.bookObj.func_77978_p();
            this.bookPages = nbttagcompound.func_150295_c("pages", 8);
            if (this.bookPages != null) {
                this.bookPages = (NBTTagList)this.bookPages.func_74737_b();
                this.bookTotalPages = this.bookPages.func_74745_c();
                if (this.bookTotalPages < 1) {
                    this.bookTotalPages = 1;
                }
            }
        }
        if (this.bookPages == null && isWrite) {
            this.bookPages = new NBTTagList();
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            this.bookTotalPages = 1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.updateCount;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 4 + this.bookImageHeight, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        this.buttonNextPage = new NextPageButton(1, (this.field_146294_l - this.bookImageWidth) / 2 + 120, 156, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, (this.field_146294_l - this.bookImageWidth) / 2 + 38, 156, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        ItemStack stack = this.bookObj;
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74782_a("pages", (NBTBase)this.bookPages);
        LuckyRecipeMaker.networkWrapper.sendToServer((IMessage)new MessageSaveNBTToBook(stack));
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = !this.field_146480_s && (this.currPage < this.bookTotalPages - 1 || this.bookIsUnsigned);
        this.buttonPreviousPage.field_146125_m = !this.field_146480_s && this.currPage > 0;
        this.buttonDone.field_146125_m = !this.bookIsUnsigned || !this.field_146480_s;
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn.field_146124_l) {
            if (btn.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (btn.field_146127_k == 1) {
                if (this.currPage < this.bookTotalPages - 1) {
                    ++this.currPage;
                } else if (this.bookIsUnsigned) {
                    this.addNewPage();
                    if (this.currPage < this.bookTotalPages - 1) {
                        ++this.currPage;
                    }
                }
            } else if (btn.field_146127_k == 2 && this.currPage > 0) {
                --this.currPage;
            }
            this.updateButtons();
        }
    }

    private void addNewPage() {
        if (this.bookPages != null && this.bookPages.func_74745_c() < 50) {
            this.bookPages.func_74742_a((NBTBase)new NBTTagString(""));
            ++this.bookTotalPages;
            this.field_146481_r = true;
        }
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        super.func_73869_a(p_73869_1_, p_73869_2_);
        this.keyTypedInBook(p_73869_1_, p_73869_2_);
    }

    private void keyTypedInBook(char p_146463_1_, int p_146463_2_) {
        switch (p_146463_1_) {
            case '\u0016': {
                this.addStringToNBTList(GuiScreen.func_146277_j());
            }
        }
        switch (p_146463_2_) {
            case 14: {
                String s = this.getTextFromPage();
                if (s.length() > 0) {
                    this.setStringToNBTList(s.substring(0, s.length() - 1));
                }
                return;
            }
            case 28: 
            case 156: {
                this.addStringToNBTList("\n");
                return;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)p_146463_1_)) {
            this.addStringToNBTList(Character.toString(p_146463_1_));
        }
    }

    private String getTextFromPage() {
        return this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c() ? this.bookPages.func_150307_f(this.currPage) : "";
    }

    private void setStringToNBTList(String p_146457_1_) {
        if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
            this.bookPages.func_150304_a(this.currPage, (NBTBase)new NBTTagString(p_146457_1_));
            this.field_146481_r = true;
        }
    }

    private void addStringToNBTList(String p_146459_1_) {
        String s1 = this.getTextFromPage();
        String s2 = s1 + p_146459_1_;
        int i = this.field_146289_q.func_78267_b(s2 + "" + EnumChatFormatting.BLACK + "_", 118);
        if (i <= 118 && s2.length() < 256) {
            this.setStringToNBTList(s2);
        }
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        int k = (this.field_146294_l - this.bookImageWidth) / 2;
        int b0 = 2;
        this.func_73729_b(k, 2, 0, 0, this.bookImageWidth, this.bookImageHeight);
        if (this.field_146480_s) {
            String s = this.bookTitle;
            if (this.bookIsUnsigned) {
                s = this.updateCount / 6 % 2 == 0 ? s + "" + EnumChatFormatting.BLACK + "_" : s + "" + EnumChatFormatting.GRAY + "_";
            }
            String s2 = I18n.func_135052_a((String)"book.editTitle", (Object[])new Object[0]);
            int l = this.field_146289_q.func_78256_a(s2);
            this.field_146289_q.func_78276_b(s2, k + 36 + (116 - l) / 2, 34, 0);
            int i1 = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b(s, k + 36 + (116 - i1) / 2, 50, 0);
            String s3 = I18n.func_135052_a((String)"book.finalizeWarning", (Object[])new Object[0]);
            this.field_146289_q.func_78279_b(s3, k + 36, 82, 116, 0);
        } else {
            String s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
            String s2 = "";
            if (this.bookPages != null && this.currPage >= 0 && this.currPage < this.bookPages.func_74745_c()) {
                s2 = this.bookPages.func_150307_f(this.currPage);
            }
            if (this.bookIsUnsigned) {
                s2 = this.field_146289_q.func_78260_a() ? s2 + "_" : (this.updateCount / 6 % 2 == 0 ? s2 + "" + EnumChatFormatting.BLACK + "_" : s2 + "" + EnumChatFormatting.GRAY + "_");
            }
            int l = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_78276_b(s, k - l + this.bookImageWidth - 44, 18, 0);
            this.field_146289_q.func_78279_b(s2, k + 36, 34, 116, 0);
        }
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean field_146151_o;
        private static final String __OBFID = "CL_00000745";

        public NextPageButton(int p_i1079_1_, int p_i1079_2_, int p_i1079_3_, boolean p_i1079_4_) {
            super(p_i1079_1_, p_i1079_2_, p_i1079_3_, 23, 13, "");
            this.field_146151_o = p_i1079_4_;
        }

        public void func_146112_a(Minecraft p_146112_1_, int p_146112_2_, int p_146112_3_) {
            if (this.field_146125_m) {
                boolean flag = p_146112_2_ >= this.field_146128_h && p_146112_3_ >= this.field_146129_i && p_146112_2_ < this.field_146128_h + this.field_146120_f && p_146112_3_ < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                p_146112_1_.func_110434_K().func_110577_a(bookGuiTextures);
                int k = 0;
                int l = 192;
                if (flag) {
                    k += 23;
                }
                if (!this.field_146151_o) {
                    l += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, 23, 13);
            }
        }
    }
}

