/*
 * Decompiled with CFR 0.152.
 */
package su.luckycraft.recipemaker.client.helper;

import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class TextureAtlasSheet
extends TextureAtlasSprite {
    private final int index;
    private final int rows;
    private final int columns;

    public static IIcon[] unstitchIcons(IIconRegister iconRegister, String name, int numIcons) {
        return TextureAtlasSheet.unstitchIcons(iconRegister, name, numIcons, 1);
    }

    public static IIcon[] unstitchIcons(IIconRegister iconRegister, String name, int columns, int rows) {
        TextureMap textureMap = (TextureMap)iconRegister;
        int numIcons = rows * columns;
        IIcon[] icons = new IIcon[numIcons];
        for (int i = 0; i < numIcons; ++i) {
            String texName = name + "." + i;
            TextureAtlasSheet texture = new TextureAtlasSheet(texName, i, rows, columns);
            textureMap.setTextureEntry(texName, (TextureAtlasSprite)texture);
            icons[i] = texture;
        }
        return icons;
    }

    private TextureAtlasSheet(String name, int index, int rows, int columns) {
        super(name);
        this.index = index;
        this.rows = rows;
        this.columns = columns;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(IResourceManager manager, ResourceLocation location) {
        BufferedImage subImage;
        BufferedImage image;
        int split = (location = new ResourceLocation(location.func_110624_b(), location.func_110623_a().replace("." + this.index, ""))).func_110623_a().indexOf(58);
        if (split != -1) {
            location = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring(0, split));
        }
        location = new ResourceLocation(location.func_110624_b(), "textures/blocks/" + location.func_110623_a() + ".png");
        IResource resource = null;
        try {
            resource = manager.func_110536_a(location);
            image = ImageIO.read(resource.func_110527_b());
        }
        catch (IOException ex) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (resource != null) {
                try {
                    resource.func_110527_b().close();
                }
                catch (IOException iOException) {}
            }
        }
        int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        int size = image.getHeight() / this.rows;
        int x = this.index % this.columns;
        int y = this.index / this.columns;
        try {
            subImage = image.getSubimage(x * size, y * size, size, size);
        }
        catch (RasterFormatException ex2) {
            return true;
        }
        this.field_130224_d = subImage.getHeight();
        this.field_130223_c = subImage.getWidth();
        int[] rgbaData = new int[this.field_130224_d * this.field_130223_c];
        subImage.getRGB(0, 0, this.field_130223_c, this.field_130224_d, rgbaData, 0, this.field_130223_c);
        int[][] imageData = new int[1 + mipmapLevels][];
        imageData[0] = rgbaData;
        this.field_110976_a.add(imageData);
        return false;
    }
}

