/*
 * Decompiled with CFR 0.152.
 */
package su.luckycraft.recipemaker.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import su.luckycraft.recipemaker.common.tile.TileAlchemicalChemistry;
import su.luckycraft.recipemaker.common.tile.TileArcaneWorkbanch;
import su.luckycraft.recipemaker.common.tile.TileBloodAltar;
import su.luckycraft.recipemaker.common.tile.TileBloodOrbRecipes;
import su.luckycraft.recipemaker.common.tile.TileCompressor;
import su.luckycraft.recipemaker.common.tile.TileCrucible;
import su.luckycraft.recipemaker.common.tile.TileEntityCraftTweaker;
import su.luckycraft.recipemaker.common.tile.TileExtremalCrafting;
import su.luckycraft.recipemaker.common.tile.TileInductionSmelter;
import su.luckycraft.recipemaker.common.tile.TileInfusion;
import su.luckycraft.recipemaker.common.tile.TileManaPool;
import su.luckycraft.recipemaker.common.tile.TileMolecularTransformer;
import su.luckycraft.recipemaker.common.tile.TilePetalApothecary;
import su.luckycraft.recipemaker.common.tile.TilePureDaise;
import su.luckycraft.recipemaker.common.tile.TileQED;
import su.luckycraft.recipemaker.common.tile.TileRuneAltar;
import su.luckycraft.recipemaker.common.tile.TileVanilla;

public class MessageSaveCraft
implements IMessage {
    private int worldId;
    private int x;
    private int y;
    private int z;
    private boolean shaped;
    private boolean mirror;
    private boolean ore;
    private boolean tag;
    private int energy;
    private boolean infusion;
    private boolean alchemy;
    private boolean conjuration;
    private int chance;

    public MessageSaveCraft() {
    }

    public MessageSaveCraft(int worldId, int x, int y, int z, boolean shaped, boolean mirror, boolean ore, boolean tag) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.shaped = shaped;
        this.mirror = mirror;
        this.ore = ore;
        this.tag = tag;
        this.energy = 0;
        this.infusion = false;
        this.alchemy = false;
        this.conjuration = false;
        this.chance = 0;
    }

    public MessageSaveCraft(int worldId, int x, int y, int z) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.shaped = false;
        this.mirror = false;
        this.ore = false;
        this.tag = false;
        this.energy = 0;
        this.infusion = false;
        this.alchemy = false;
        this.conjuration = false;
        this.chance = 0;
    }

    public MessageSaveCraft(int worldId, int x, int y, int z, int energy, int chance) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.shaped = false;
        this.mirror = false;
        this.ore = false;
        this.tag = false;
        this.energy = energy;
        this.infusion = false;
        this.alchemy = false;
        this.conjuration = false;
        this.chance = chance;
    }

    public MessageSaveCraft(int worldId, int x, int y, int z, int energy) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.shaped = false;
        this.mirror = false;
        this.ore = false;
        this.tag = false;
        this.energy = energy;
        this.chance = 0;
    }

    public MessageSaveCraft(int worldId, int x, int y, int z, int energy, boolean tag) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.shaped = false;
        this.mirror = false;
        this.ore = false;
        this.tag = tag;
        this.energy = energy;
        this.chance = 0;
    }

    public MessageSaveCraft(int worldId, int x, int y, int z, int energy, boolean infusion, boolean alchemy, boolean conjuration) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.shaped = false;
        this.mirror = false;
        this.ore = false;
        this.tag = false;
        this.energy = energy;
        this.infusion = infusion;
        this.alchemy = alchemy;
        this.conjuration = conjuration;
        this.chance = 0;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buff = new PacketBuffer(buf);
        this.worldId = buff.readInt();
        this.x = buff.readInt();
        this.y = buff.readInt();
        this.z = buff.readInt();
        this.shaped = buff.readBoolean();
        this.mirror = buff.readBoolean();
        this.ore = buff.readBoolean();
        this.tag = buff.readBoolean();
        this.energy = buff.readInt();
        this.infusion = buff.readBoolean();
        this.alchemy = buff.readBoolean();
        this.conjuration = buff.readBoolean();
        this.chance = buff.readInt();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buff = new PacketBuffer(buf);
        buff.writeInt(this.worldId);
        buff.writeInt(this.x);
        buff.writeInt(this.y);
        buff.writeInt(this.z);
        buff.writeBoolean(this.shaped);
        buff.writeBoolean(this.mirror);
        buff.writeBoolean(this.ore);
        buff.writeBoolean(this.tag);
        buff.writeInt(this.energy);
        buff.writeBoolean(this.infusion);
        buff.writeBoolean(this.alchemy);
        buff.writeBoolean(this.conjuration);
        buff.writeInt(this.chance);
    }

    public static class Handler
    implements IMessageHandler<MessageSaveCraft, IMessage> {
        public IMessage onMessage(MessageSaveCraft message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                boolean isOp = player.field_71133_b.func_71203_ab().func_152596_g(player.func_146103_bH());
                if (!isOp) {
                    System.out.println("\u0418\u0433\u0440\u043e\u043a" + player.getDisplayName() + " \u043f\u043e\u043f\u044b\u0442\u0430\u043b\u0441\u044f \u043e\u0442\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0440\u0430\u0444\u0442\u044b \u043d\u0435 \u0438\u043c\u0435\u044f \u043f\u0440\u0430\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
                    return null;
                }
                WorldServer world = DimensionManager.getWorld((int)message.worldId);
                TileEntity te = world.func_147438_o(message.x, message.y, message.z);
                if (te instanceof TileEntityCraftTweaker) {
                    int meta = te.func_145832_p();
                    switch (meta) {
                        case 0: {
                            ((TileVanilla)te).outputRecipeToFile(message.shaped, message.mirror, message.ore, message.tag);
                            break;
                        }
                        case 1: {
                            ((TileMolecularTransformer)te).outputRecipeToFile((int)(message.energy > Integer.MAX_VALUE ? 2.147483647E9 : (double)message.energy));
                            break;
                        }
                        case 2: {
                            ((TileExtremalCrafting)te).outputRecipeToFile(message.shaped, message.ore, message.tag);
                            break;
                        }
                        case 3: {
                            ((TileManaPool)te).outputRecipeToFile(message.energy, message.infusion, message.alchemy, message.conjuration);
                            break;
                        }
                        case 4: {
                            ((TilePetalApothecary)te).outputRecipeToFile();
                            break;
                        }
                        case 5: {
                            ((TilePureDaise)te).outputRecipeToFile();
                            break;
                        }
                        case 6: {
                            ((TileRuneAltar)te).outputRecipeToFile(message.energy);
                            break;
                        }
                        case 7: {
                            ((TileQED)te).outputRecipeToFile(message.tag, message.ore);
                            break;
                        }
                        case 8: {
                            ((TileCompressor)te).outputRecipeToFile();
                            break;
                        }
                        case 9: {
                            ((TileArcaneWorkbanch)te).outputRecipeToFile(message.shaped, message.ore);
                            break;
                        }
                        case 10: {
                            ((TileCrucible)te).outputRecipeToFile();
                            break;
                        }
                        case 11: {
                            ((TileInfusion)te).outputRecipeToFile();
                            break;
                        }
                        case 12: {
                            ((TileInductionSmelter)te).outputRecipeToFile(message.energy, message.chance);
                            break;
                        }
                        case 13: {
                            ((TileAlchemicalChemistry)te).outputRecipeToFile(message.energy, message.tag);
                            break;
                        }
                        case 14: {
                            ((TileBloodOrbRecipes)te).outputRecipeToFile(message.shaped, message.ore, message.tag);
                            break;
                        }
                        case 15: {
                            ((TileBloodAltar)te).outputRecipeToFile(message.energy, message.chance);
                        }
                    }
                }
            }
            return null;
        }
    }
}

