/*
 * Decompiled with CFR 0.152.
 */
package su.luckycraft.recipemaker.common.tile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import su.luckycraft.recipemaker.common.blocks.KitBlock;

public class KitTileEntity
extends TileEntity
implements IInventory {
    public static final int SIZE = 36;
    public ItemStack[] inventory;
    public int numUsingPlayers;

    public KitTileEntity() {
        this.createInventory();
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.numUsingPlayers = j;
            return true;
        }
        return false;
    }

    public void createInventory() {
        this.inventory = new ItemStack[36];
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 36);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        if (this.func_145838_q() != null && this.func_145838_q() instanceof KitBlock) {
            --this.numUsingPlayers;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    public int func_70302_i_() {
        return 36;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int number) {
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a <= number) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            this.func_70296_d();
            return itemstack;
        }
        ItemStack itemstack = this.inventory[slot].func_77979_a(number);
        if (this.inventory[slot].field_77994_a == 0) {
            this.inventory[slot] = null;
        }
        this.func_70296_d();
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "container.vrecipes";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public void outputRecipeToFile(String name) {
        int i;
        File file;
        PrintWriter out;
        BufferedWriter bw;
        FileWriter fw;
        if (name == "") {
            return;
        }
        try {
            fw = new FileWriter("kit.yml", true);
            bw = new BufferedWriter(fw);
            out = new PrintWriter(bw);
            file = new File("kit.yml");
            if (file.length() == 0L) {
                out.println("kit:");
            }
            out.println("   " + name + ":");
            out.println("    items:");
            for (i = 0; i < 36; ++i) {
                if (this.func_70301_a(i) == null) continue;
                String[] namefoitem = this.func_70301_a((int)i).func_77973_b().delegate.name().split(":");
                out.println("    - " + namefoitem[0] + "_" + namefoitem[1] + ":" + this.func_70301_a(i).func_77960_j() + " " + this.func_70301_a((int)i).field_77994_a);
            }
            out.close();
            bw.close();
            fw.close();
            System.out.println("Save kit - " + name);
        }
        catch (IOException e) {
            System.out.println("ERROR " + e.getLocalizedMessage());
        }
        try {
            fw = new FileWriter("kits.yml", true);
            bw = new BufferedWriter(fw);
            out = new PrintWriter(bw);
            file = new File("kits.yml");
            if (file.length() == 0L) {
                out.println("kit:");
            }
            out.println("   " + name + ":");
            out.println("    items:");
            for (i = 0; i < 36; ++i) {
                if (this.func_70301_a(i) == null) continue;
                PrintWriter printWriter = out;
                StringBuilder append = new StringBuilder().append("    - ");
                this.func_70301_a(i).func_77973_b();
                printWriter.println(append.append(Item.func_150891_b((Item)this.func_70301_a(i).func_77973_b())).append(":").append(this.func_70301_a(i).func_77960_j()).append(" ").append(this.func_70301_a((int)i).field_77994_a).toString());
            }
            out.close();
            bw.close();
            fw.close();
            System.out.println("Save kits - " + name);
        }
        catch (IOException e) {
            System.out.println("ERROR " + e.getLocalizedMessage());
        }
    }
}

