/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Button;
import codechicken.nei.Image;
import codechicken.nei.ItemPanels;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.LayoutStyle;
import codechicken.nei.drawable.DrawableBuilder;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;

public class LayoutStyleMinecraft
extends LayoutStyle {
    public int buttonCount;
    public int leftSize;
    public int numButtons;

    @Override
    public String getName() {
        return "minecraft";
    }

    @Override
    public void init() {
        LayoutManager.delete.icon = new Image(144, 12, 12, 12);
        LayoutManager.rain.icon = new Image(120, 12, 12, 12);
        LayoutManager.gamemode.icons[0] = new Image(132, 12, 12, 12);
        LayoutManager.gamemode.icons[1] = new Image(156, 12, 12, 12);
        LayoutManager.gamemode.icons[2] = new Image(168, 12, 12, 12);
        LayoutManager.magnet.icon = new Image(180, 24, 12, 12);
        LayoutManager.timeButtons[0].icon = new Image(132, 24, 12, 12);
        LayoutManager.timeButtons[1].icon = new Image(120, 24, 12, 12);
        LayoutManager.timeButtons[2].icon = new Image(144, 24, 12, 12);
        LayoutManager.timeButtons[3].icon = new Image(156, 24, 12, 12);
        LayoutManager.heal.icon = new Image(168, 24, 12, 12);
        LayoutManager.itemPresenceOverlays[0] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 0, 40, 8, 8).build();
        LayoutManager.itemPresenceOverlays[1] = new DrawableBuilder("nei:textures/nei_tabbed_sprites.png", 8, 40, 8, 8).build();
    }

    @Override
    public void reset() {
        this.buttonCount = 0;
    }

    @Override
    public void layout(GuiContainer gui, VisiblityData visiblity) {
        this.reset();
        this.leftSize = ItemPanels.bookmarkPanel.getWidth(gui);
        this.numButtons = Math.max(this.leftSize / 18, 1);
        LayoutManager.delete.state = 4;
        if (NEIController.getDeleteMode()) {
            LayoutManager.delete.state |= 1;
        } else if (!visiblity.enableDeleteMode) {
            LayoutManager.delete.state |= 2;
        }
        LayoutManager.rain.state = 4;
        if (NEIClientConfig.disabledActions.contains("rain")) {
            LayoutManager.rain.state |= 2;
        } else if (NEIClientUtils.isRaining()) {
            LayoutManager.rain.state |= 1;
        }
        LayoutManager.gamemode.state = 4;
        if (NEIClientUtils.getGamemode() != 0) {
            LayoutManager.gamemode.state |= 1;
            LayoutManager.gamemode.index = NEIClientUtils.getGamemode() - 1;
        } else if (NEIClientUtils.isValidGamemode("creative")) {
            LayoutManager.gamemode.index = 0;
        } else if (NEIClientUtils.isValidGamemode("creative+")) {
            LayoutManager.gamemode.index = 1;
        } else if (NEIClientUtils.isValidGamemode("adventure")) {
            LayoutManager.gamemode.index = 2;
        }
        LayoutManager.bookmarksButton.index = NEIClientConfig.isBookmarkPanelHidden() ? 0 : 1;
        LayoutManager.options.index = NEIClientConfig.getCheatMode();
        LayoutManager.magnet.state = 4 | (NEIClientConfig.getMagnetMode() ? 1 : 0);
        if (NEIClientConfig.canPerformAction("delete")) {
            this.layoutButton(LayoutManager.delete);
        }
        if (NEIClientConfig.canPerformAction("rain")) {
            this.layoutButton(LayoutManager.rain);
        }
        if (NEIClientUtils.isValidGamemode("creative") || NEIClientUtils.isValidGamemode("creative+") || NEIClientUtils.isValidGamemode("adventure")) {
            this.layoutButton(LayoutManager.gamemode);
        }
        if (NEIClientConfig.canPerformAction("magnet")) {
            this.layoutButton(LayoutManager.magnet);
        }
        if (NEIClientConfig.canPerformAction("time")) {
            for (int i = 0; i < 4; ++i) {
                LayoutManager.timeButtons[i].state = NEIClientConfig.disabledActions.contains(NEIActions.timeZones[i]) ? 2 : 0;
                this.layoutButton(LayoutManager.timeButtons[i]);
            }
        }
        if (NEIClientConfig.canPerformAction("heal")) {
            this.layoutButton(LayoutManager.heal);
        }
        LayoutManager.itemPanel.resize(gui);
        LayoutManager.bookmarkPanel.resize(gui);
        LayoutManager.options.x = NEIClientConfig.isEnabled() ? 0 : 6;
        LayoutManager.options.y = NEIClientConfig.isEnabled() ? gui.field_146295_m - 22 : gui.field_146295_m - 28;
        LayoutManager.options.w = 22;
        LayoutManager.options.h = 22;
        LayoutManager.bookmarksButton.x = 24 + (NEIClientConfig.isEnabled() ? 0 : 6);
        LayoutManager.bookmarksButton.y = NEIClientConfig.isEnabled() ? gui.field_146295_m - 22 : gui.field_146295_m - 28;
        LayoutManager.bookmarksButton.w = 22;
        LayoutManager.bookmarksButton.h = 22;
        LayoutManager.dropDown.h = 18;
        LayoutManager.dropDown.w = 150;
        LayoutManager.dropDown.y = 0;
        LayoutManager.dropDown.x = (gui.field_146294_l - gui.field_146999_f) / 2 + gui.field_146999_f - LayoutManager.dropDown.w;
        LayoutManager.presetsPanel.h = 16;
        LayoutManager.presetsPanel.w = 150;
        LayoutManager.presetsPanel.y = 2;
        LayoutManager.presetsPanel.x = (gui.field_146294_l - gui.field_146999_f) / 2 + gui.field_146999_f - LayoutManager.presetsPanel.w;
        LayoutManager.searchField.h = 20;
        if (NEIClientConfig.isSearchWidgetCentered()) {
            LayoutManager.searchField.w = 150;
            LayoutManager.searchField.x = (gui.field_146294_l - LayoutManager.searchField.w) / 2;
        } else {
            LayoutManager.searchField.w = (int)((double)LayoutManager.itemPanel.w * (NEIClientConfig.showItemQuantityWidget() ? 0.7 : 1.0));
            LayoutManager.searchField.x = LayoutManager.itemPanel.x;
        }
        LayoutManager.searchField.y = gui.field_146295_m - LayoutManager.searchField.h - 2;
        if (!visiblity.showItemSection) {
            LayoutManager.searchField.setFocus(false);
        }
    }

    public void layoutButton(Button button) {
        button.x = 2 + this.buttonCount % this.numButtons * 19;
        button.y = 2 + this.buttonCount / this.numButtons * 18;
        button.h = 17;
        button.w = button.contentWidth() + 6;
        ++this.buttonCount;
    }

    @Override
    public void drawButton(Button b, int mousex, int mousey) {
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int tex = (b.state & 3) == 2 ? 0 : ((b.state & 4) == 0 && b.contains(mousex, mousey) || (b.state & 3) == 1 ? 2 : 1);
        LayoutManager.drawButtonBackground(b.x, b.y, b.w, b.h, true, tex);
        Image icon = b.getRenderIcon();
        if (icon == null) {
            int colour = tex == 2 ? 0xFFFFA0 : (tex == 0 ? 0x601010 : 0xE0E0E0);
            GuiDraw.drawStringC((String)b.getRenderLabel(), (int)(b.x + b.w / 2), (int)(b.y + (b.h - 8) / 2), (int)colour);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconX = b.x + (b.w - icon.width) / 2;
            int iconY = b.y + (b.h - icon.height) / 2;
            LayoutManager.drawIcon(iconX, iconY, icon);
        }
    }

    @Override
    public void drawSubsetTag(String text, int x, int y, int w, int h, int state, boolean mouseover) {
        if (state == 1) {
            GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        LayoutManager.drawButtonBackground(x, y, w, h, false, state == 0 ? 0 : 1);
        if (text != null) {
            GuiDraw.drawStringC((String)text, (int)x, (int)y, (int)w, (int)h, (int)(state == 2 ? -2039584 : -6250336));
        }
    }
}

