/*
 * Decompiled with CFR 0.152.
 */
package ru.samopis.photon.bloader.displayer;

import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import java.awt.Color;
import java.awt.SplashScreen;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.SharedDrawable;
import ru.samopis.photon.bloader.displayer.ProgressDisplayer;
import ru.samopis.photon.bloader.displayer.item.ColorRect;
import ru.samopis.photon.bloader.displayer.item.DisplayedItem;
import ru.samopis.photon.bloader.displayer.item.Image;
import ru.samopis.photon.bloader.displayer.item.LoadingBar;
import ru.samopis.photon.bloader.displayer.item.Text;
import ru.samopis.photon.bloader.util.OperationController;

public class MinecraftDisplayer
implements ProgressDisplayer.IDisplayer {
    private static final String defaultSound = "random.levelup";
    private final CountDownLatch latch = new CountDownLatch(1);
    private Drawable draw;
    private DisplayedItem[] images;
    private ScaledResolution resolution;
    private Minecraft mc;
    private IResourcePack myPack;
    private boolean isActive = false;
    private String text;
    private float percent;

    public static void playFinishedSound() {
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        PositionedSoundRecord sound = PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation(defaultSound));
        soundHandler.func_147682_a((ISound)sound);
    }

    private List<IResourcePack> getOnlyList() {
        for (Field f : this.mc.getClass().getDeclaredFields()) {
            if (!f.getType().equals(List.class) || Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                return (List)f.get(this.mc);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void start() {
        this.mc = Minecraft.func_71410_x();
        this.myPack = !ProgressDisplayer.coreModLocation.isDirectory() ? new FMLFileResourcePack(ProgressDisplayer.modContainer) : new FMLFolderResourcePack(ProgressDisplayer.modContainer);
        this.getOnlyList().add(this.myPack);
        this.mc.func_110436_a();
        try {
            this.draw = new SharedDrawable(Display.getDrawable());
            Display.getDrawable().releaseContext();
            this.draw.makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        Thread controller = new Thread((Runnable)new LoadingScreenRenderer(this), "Loading Screen Renderer");
        controller.start();
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (splashScreen != null) {
            splashScreen.close();
        }
    }

    @Override
    public void displayProgress(String text, float percent) {
        this.text = text;
        this.percent = percent;
    }

    private synchronized void changeScreen() {
        try {
            if (!Display.isCurrent()) {
                this.draw.releaseContext();
                Display.getDrawable().makeCurrent();
            }
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void loadDisplayedItems() {
        int width = this.resolution.func_78326_a();
        int height = this.resolution.func_78328_b();
        Color black = new Color(255, 255, 255, 255);
        Color gray = new Color(38, 38, 38, 255);
        Color salat = new Color(255, 102, 0, 255);
        this.images = new DisplayedItem[]{new Image("/assets/bloader/textures/gui/splash.png", Image.ImageType.STATIC, 0, 0, width, height), new ColorRect(gray, width / 4, (int)((double)height / 1.2 + 8.0), width / 4 + width / 2, (int)((double)height / 1.2 + 8.0 + 10.0)), new LoadingBar(salat, width / 4, (int)((double)height / 1.2 + 8.0), width / 2, 10)};
    }

    public void drawImageRender(DisplayedItem render, String text, double percent) {
        switch (render.getRenderType()) {
            case IMAGE: {
                Image imageRender = (Image)render;
                if (imageRender.getImageType() == Image.ImageType.DYNAMIC) {
                    imageRender.setDynamicWidth((int)(percent * (double)this.resolution.func_78326_a()), (float)percent);
                }
                render.draw();
                break;
            }
            case TEXT: {
                Text textRender = (Text)render;
                if (textRender.getTextType() == Text.TextType.PERCENT) {
                    textRender.setText(text);
                }
                if (textRender.getTextType() == Text.TextType.CENTERED) {
                    textRender.setText(text);
                }
                textRender.draw();
                break;
            }
            case RECT: {
                ColorRect colorRect = (ColorRect)render;
                colorRect.draw();
                break;
            }
            case LOADINGBAR: {
                LoadingBar loader = (LoadingBar)render;
                loader.setProgress(percent);
                loader.draw();
                break;
            }
        }
    }

    private void preDisplayScreen() {
        this.resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.resolution.func_78326_a(), (double)this.resolution.func_78328_b(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void postDisplayScreen() {
        this.mc.func_147120_f();
    }

    @Override
    public void close() {
        this.getOnlyList().remove(this.myPack);
        this.isActive = false;
        try {
            this.latch.await();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.changeScreen();
        this.initGL();
    }

    private void initGL() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71443_c = Display.getWidth();
        mc.field_71440_d = Display.getHeight();
        mc.func_71370_a(mc.field_71443_c, mc.field_71440_d);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    private static class LoadingScreenRenderer
    implements Runnable {
        private final MinecraftDisplayer parent;

        public LoadingScreenRenderer(MinecraftDisplayer parent) {
            this.parent = parent;
            parent.isActive = true;
        }

        @Override
        public void run() {
            OperationController controller = new OperationController(30);
            this.parent.changeScreen();
            while (this.parent.isActive) {
                long i;
                controller.updateLastTickTime();
                if (this.parent.draw == null) {
                    i = controller.calculateSleepTime();
                    try {
                        this.sleep(controller, i);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    i = controller.calculateSleepTime();
                    this.draw();
                    this.sleep(controller, i);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                Display.getDrawable().releaseContext();
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            this.parent.latch.countDown();
        }

        private void draw() {
            this.parent.resolution = new ScaledResolution(this.parent.mc, ((MinecraftDisplayer)this.parent).mc.field_71443_c, ((MinecraftDisplayer)this.parent).mc.field_71440_d);
            this.parent.preDisplayScreen();
            if (Display.wasResized() || this.parent.images == null) {
                this.parent.loadDisplayedItems();
            }
            for (DisplayedItem image : this.parent.images) {
                this.parent.drawImageRender(image, this.parent.text, this.parent.percent);
            }
            this.parent.postDisplayScreen();
        }

        private void sleep(OperationController controller, long i) throws InterruptedException {
            if (i >= 0L) {
                Thread.sleep(i);
            }
        }
    }
}

