/*
 * Decompiled with CFR 0.152.
 */
package ru.samopis.photon.bloader.displayer.item;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import ru.samopis.photon.bloader.displayer.item.DisplayedItem;
import ru.samopis.photon.bloader.truetyper.FontHelper;
import ru.samopis.photon.bloader.truetyper.FontLoader;
import ru.samopis.photon.bloader.truetyper.TrueTypeFont;

public class Text
extends DisplayedItem {
    private String text;
    private final TextType textType;
    private final Color color;

    public Text(TextType textType, String text, Color color, int x, int y) {
        super(DisplayedItem.RenderType.TEXT, x, y);
        this.text = text;
        this.textType = textType;
        this.color = color;
    }

    public TextType getTextType() {
        return this.textType;
    }

    public void setText(String value) {
        this.text = value;
    }

    public void setPercent(double percent) {
        String text = Math.round(percent * 100.0) + "%";
        this.setText(text);
    }

    @Override
    public void draw() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int size = 8 * scaledResolution.func_78325_e();
        TrueTypeFont font = FontLoader.getFont(size);
        switch (this.textType) {
            case CENTERED: {
                FontHelper.drawString(this.text, (float)this.x - font.getWidth(this.text) / 4.0f, this.y + 6, font, this.color.getRGB());
                break;
            }
            case PERCENT: 
            case STANDART: {
                FontHelper.drawString(this.text, this.x + 4, this.y, font, this.color.getRGB());
            }
        }
    }

    public static enum TextType {
        STANDART,
        CENTERED,
        PERCENT;

    }
}

