/*
 * Decompiled with CFR 0.152.
 */
package ru.samopis.photon.bloader.util;

public class OperationController {
    private final int ticks;
    private final int millisecond;
    private long lastTickTime;

    public OperationController(int tickPerSecond) {
        this.ticks = tickPerSecond;
        this.millisecond = 1000 / this.ticks;
    }

    public int getTicksInSecond() {
        return this.ticks;
    }

    public int getMillisForTick() {
        return this.millisecond;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public void updateLastTickTime() {
        this.lastTickTime = this.getCurrentTime();
    }

    public long getLastTickTime() {
        return this.lastTickTime;
    }

    public long calculateSleepTime() {
        return (long)this.getMillisForTick() - this.getDifference();
    }

    private long getDifference() {
        return this.getCurrentTime() - this.getLastTickTime();
    }
}

