/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.Avaritia;
import fox.spiteful.avaritia.entity.EntityImmortalItem;
import fox.spiteful.avaritia.items.LudicrousItems;
import fox.spiteful.avaritia.render.IHaloRenderItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemResource
extends Item
implements IHaloRenderItem {
    private static final String[] types = new String[]{"diamond_lattice", "crystal_matrix_ingot", "neutron_pile", "neutron_nugget", "neutronium_ingot", "infinity_catalyst", "infinity_ingot", "record_fragment", "starfuel", "neutronium_gear"};
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] halo;

    public ItemResource() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("avaritia_resource");
        this.func_77637_a(Avaritia.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icons = new IIcon[types.length];
        for (int x = 0; x < types.length; ++x) {
            this.icons[x] = ir.func_94245_a("avaritia:resource_" + types[x]);
        }
        this.halo = new IIcon[2];
        this.halo[0] = ir.func_94245_a("avaritia:halo");
        this.halo[1] = ir.func_94245_a("avaritia:halonoise");
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List tooltip, boolean wut) {
        int meta = item.func_77960_j();
        if (meta != 0 && meta < 8) {
            tooltip.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + types[meta] + ".desc")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int dam) {
        return this.icons[dam % this.icons.length];
    }

    public String func_77667_c(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(types.length - 1));
        return super.func_77658_a() + "." + types[i];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < types.length; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: 
            case 2: 
            case 3: {
                return EnumRarity.uncommon;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                return EnumRarity.rare;
            }
            case 5: {
                return EnumRarity.epic;
            }
            case 6: {
                return LudicrousItems.cosmic;
            }
        }
        return EnumRarity.common;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean drawHalo(ItemStack stack) {
        int meta = stack.func_77960_j();
        return meta >= 2 && meta <= 6 || meta >= 8;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getHaloTexture(ItemStack stack) {
        int meta = stack.func_77960_j();
        return meta != 2 && meta != 3 && meta != 4 && meta != 9 ? this.halo[0] : this.halo[1];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHaloSize(ItemStack stack) {
        int meta = stack.func_77960_j();
        switch (meta) {
            case 5: 
            case 6: {
                return 10;
            }
        }
        return 8;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean drawPulseEffect(ItemStack stack) {
        int meta = stack.func_77960_j();
        return meta == 5 || meta == 6;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHaloColour(ItemStack stack) {
        int meta = stack.func_77960_j();
        return meta == 2 ? 0x33FFFFFF : (meta == 3 ? 0x4DFFFFFF : (meta != 4 && meta != 9 ? -16777216 : -1711276033));
    }

    public boolean hasCustomEntity(ItemStack stack) {
        int meta = stack.func_77960_j();
        return meta == 5 || meta == 6;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        return meta != 5 && meta != 6 ? null : new EntityImmortalItem(world, location, itemstack);
    }
}

