/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.render;

import fox.spiteful.avaritia.render.IHaloRenderItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class FancyHaloRenderer
implements IItemRenderer {
    public Random rand = new Random();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        IHaloRenderItem ihri;
        Item itype = item.func_77973_b();
        if (itype instanceof IHaloRenderItem && !(ihri = (IHaloRenderItem)itype).drawHalo(item) && !ihri.drawPulseEffect(item)) {
            return false;
        }
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        boolean renderHalo = false;
        boolean renderPulse = false;
        int spread = 0;
        IIcon halo = null;
        int haloColour = 0;
        Item itype = item.func_77973_b();
        if (itype instanceof IHaloRenderItem) {
            IHaloRenderItem ihri = (IHaloRenderItem)itype;
            spread = ihri.getHaloSize(item);
            halo = ihri.getHaloTexture(item);
            haloColour = ihri.getHaloColour(item);
            renderHalo = ihri.drawHalo(item);
            renderPulse = ihri.drawPulseEffect(item);
        }
        RenderItem r = RenderItem.getInstance();
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator t = Tessellator.field_78398_a;
        switch (type) {
            case INVENTORY: {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2929);
                if (renderHalo) {
                    float ca = (float)(haloColour >> 24 & 0xFF) / 255.0f;
                    float cr = (float)(haloColour >> 16 & 0xFF) / 255.0f;
                    float cg = (float)(haloColour >> 8 & 0xFF) / 255.0f;
                    float cb = (float)(haloColour & 0xFF) / 255.0f;
                    GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)ca);
                    t.func_78382_b();
                    t.func_78374_a((double)(-spread), (double)(-spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94206_g());
                    t.func_78374_a((double)(-spread), (double)(16 + spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94210_h());
                    t.func_78374_a((double)(16 + spread), (double)(16 + spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94210_h());
                    t.func_78374_a((double)(16 + spread), (double)(-spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94206_g());
                    t.func_78381_a();
                }
                if (renderPulse) {
                    GL11.glPushMatrix();
                    double xs = this.rand.nextGaussian() * 0.15 + 0.95;
                    double ox = (1.0 - xs) / 2.0;
                    GL11.glEnable((int)3042);
                    GL11.glTranslated((double)(ox * 16.0), (double)(ox * 16.0), (double)1.0);
                    GL11.glScaled((double)xs, (double)xs, (double)1.0);
                    IIcon icon = item.func_77973_b().getIcon(item, 0);
                    t.func_78382_b();
                    t.func_78369_a(1.0f, 1.0f, 1.0f, 0.6f);
                    t.func_78374_a(0.0 - ox, 0.0 - ox, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
                    t.func_78374_a(0.0 - ox, 16.0 + ox, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
                    t.func_78374_a(16.0 + ox, 16.0 + ox, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
                    t.func_78374_a(16.0 + ox, 0.0 - ox, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
                    t.func_78381_a();
                    GL11.glPopMatrix();
                }
                r.renderItemIntoGUI(mc.field_71466_p, mc.func_110434_K(), item, 0, 0, true);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2929);
                r.field_77024_a = true;
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }
}

