/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.cache;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api2.storage.DBEntry;
import betterquesting.network.handlers.NetCacheSync;
import betterquesting.questing.QuestDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class QuestCache
implements IExtendedEntityProperties {
    public static final ResourceLocation LOC_QUEST_CACHE = new ResourceLocation("betterquesting", "quest_cache");
    private final TreeSet<Integer> visibleQuests = new TreeSet();
    private final TreeSet<Integer> activeQuests = new TreeSet();
    private final TreeSet<QResetTime> resetSchedule = new TreeSet((o1, o2) -> o1.questID == o2.questID ? 0 : Long.compare(o1.time, o2.time));
    private final TreeSet<Integer> autoClaims = new TreeSet();
    private final TreeSet<Integer> markedDirty = new TreeSet();

    public void init(Entity entity, World world) {
    }

    public synchronized int[] getActiveQuests() {
        int i = 0;
        int[] aryAct = new int[this.activeQuests.size()];
        for (Integer q : this.activeQuests) {
            aryAct[i++] = q;
        }
        return aryAct;
    }

    public synchronized int[] getVisibleQuests() {
        int i = 0;
        int[] aryVis = new int[this.visibleQuests.size()];
        for (Integer q : this.visibleQuests) {
            aryVis[i++] = q;
        }
        return aryVis;
    }

    public synchronized int[] getPendingAutoClaims() {
        int i = 0;
        int[] aryAC = new int[this.autoClaims.size()];
        for (Integer q : this.autoClaims) {
            aryAC[i++] = q;
        }
        return aryAC;
    }

    public synchronized QResetTime[] getScheduledResets() {
        return this.resetSchedule.toArray(new QResetTime[0]);
    }

    public synchronized void markQuestDirty(int questID) {
        if (questID < 0) {
            return;
        }
        this.markedDirty.add(questID);
    }

    public synchronized void markQuestClean(int questID) {
        if (questID < 0) {
            return;
        }
        this.markedDirty.remove(questID);
    }

    public synchronized void cleanAllQuests() {
        this.markedDirty.clear();
    }

    public synchronized int[] getDirtyQuests() {
        int i = 0;
        int[] aryMD = new int[this.markedDirty.size()];
        for (Integer q : this.markedDirty) {
            aryMD[i++] = q;
        }
        return aryMD;
    }

    public synchronized void updateCache(@Nonnull EntityPlayer player) {
        UUID uuid = QuestingAPI.getQuestingUUID(player);
        List questDB = QuestingAPI.getAPI(ApiReference.QUEST_DB).getEntries();
        ArrayList<Integer> tmpVisible = new ArrayList<Integer>();
        ArrayList<Integer> tmpActive = new ArrayList<Integer>();
        ArrayList<QResetTime> tmpReset = new ArrayList<QResetTime>();
        ArrayList<Integer> tmpAutoClaim = new ArrayList<Integer>();
        long currentTime = System.currentTimeMillis();
        for (DBEntry entry : questDB) {
            if (((IQuest)entry.getValue()).isUnlocked(uuid) || ((IQuest)entry.getValue()).getProperty(NativeProps.LOCKED_PROGRESS).booleanValue()) {
                int repeat = ((IQuest)entry.getValue()).getProperty(NativeProps.REPEAT_TIME);
                NBTTagCompound ue = ((IQuest)entry.getValue()).getCompletionInfo(uuid);
                if (ue == null && ((IQuest)entry.getValue()).getTasks().size() <= 0 || ((IQuest)entry.getValue()).canSubmit(player)) {
                    tmpActive.add(entry.getID());
                } else if (ue != null) {
                    if (repeat >= 0 && ((IQuest)entry.getValue()).hasClaimed(uuid)) {
                        long altTime = ue.func_74763_f("timestamp");
                        if (altTime > currentTime) {
                            altTime = currentTime;
                        }
                        if (repeat > 1 && !((IQuest)entry.getValue()).getProperty(NativeProps.REPEAT_REL).booleanValue()) {
                            altTime -= altTime % (long)repeat;
                        }
                        tmpReset.add(new QResetTime(entry.getID(), altTime + (long)(repeat * 50)));
                    }
                    if (!((IQuest)entry.getValue()).hasClaimed(uuid) && ((IQuest)entry.getValue()).getProperty(NativeProps.AUTO_CLAIM).booleanValue()) {
                        tmpAutoClaim.add(entry.getID());
                    }
                }
            }
            if (!QuestCache.isQuestShown((IQuest)entry.getValue(), uuid, player)) continue;
            tmpVisible.add(entry.getID());
        }
        this.visibleQuests.clear();
        this.visibleQuests.addAll(tmpVisible);
        this.activeQuests.clear();
        this.activeQuests.addAll(tmpActive);
        this.resetSchedule.clear();
        this.resetSchedule.addAll(tmpReset);
        this.autoClaims.clear();
        this.autoClaims.addAll(tmpAutoClaim);
        if (player instanceof EntityPlayerMP) {
            NetCacheSync.sendSync((EntityPlayerMP)player);
        }
    }

    public synchronized void saveNBTData(NBTTagCompound tags) {
        tags.func_74783_a("visibleQuests", this.getVisibleQuests());
        tags.func_74783_a("activeQuests", this.getActiveQuests());
        tags.func_74783_a("autoClaims", this.getPendingAutoClaims());
        tags.func_74783_a("markedDirty", this.getDirtyQuests());
        NBTTagList tagSchedule = new NBTTagList();
        for (QResetTime entry : this.getScheduledResets()) {
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74768_a("quest", entry.questID);
            tagEntry.func_74772_a("time", entry.time);
            tagSchedule.func_74742_a((NBTBase)tagEntry);
        }
        tags.func_74782_a("resetSchedule", (NBTBase)tagSchedule);
    }

    public synchronized void loadNBTData(NBTTagCompound nbt) {
        this.visibleQuests.clear();
        this.activeQuests.clear();
        this.resetSchedule.clear();
        this.autoClaims.clear();
        this.markedDirty.clear();
        for (int i : nbt.func_74759_k("visibleQuests")) {
            this.visibleQuests.add(i);
        }
        for (int i : nbt.func_74759_k("activeQuests")) {
            this.activeQuests.add(i);
        }
        for (int i : nbt.func_74759_k("autoClaims")) {
            this.autoClaims.add(i);
        }
        for (int i : nbt.func_74759_k("markedDirty")) {
            this.markedDirty.add(i);
        }
        NBTTagList tagList = nbt.func_150295_c("resetSchedule", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagEntry = tagList.func_150305_b(i);
            if (!tagEntry.func_150297_b("quest", 99)) continue;
            this.resetSchedule.add(new QResetTime(tagEntry.func_74762_e("quest"), tagEntry.func_74763_f("time")));
        }
    }

    public static boolean isQuestShown(IQuest quest, UUID uuid, EntityPlayer player) {
        if (quest == null || uuid == null) {
            return false;
        }
        EnumQuestVisibility vis = quest.getProperty(NativeProps.VISIBILITY);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit(player) || vis == EnumQuestVisibility.ALWAYS) {
            return true;
        }
        if (vis == EnumQuestVisibility.HIDDEN) {
            return false;
        }
        if (vis == EnumQuestVisibility.SECRET) {
            return quest.isComplete(uuid) || quest.isUnlocked(uuid);
        }
        if (BQ_Settings.viewMode) {
            return true;
        }
        if (vis == EnumQuestVisibility.UNLOCKED) {
            return quest.isComplete(uuid) || quest.isUnlocked(uuid);
        }
        if (vis == EnumQuestVisibility.NORMAL) {
            if (quest.isComplete(uuid) || quest.isUnlocked(uuid)) {
                return true;
            }
            for (DBEntry q : QuestDatabase.INSTANCE.bulkLookup(quest.getRequirements())) {
                if (((IQuest)q.getValue()).isUnlocked(uuid)) continue;
                return false;
            }
            return true;
        }
        if (vis == EnumQuestVisibility.COMPLETED) {
            return quest.isComplete(uuid);
        }
        if (vis == EnumQuestVisibility.CHAIN) {
            if (quest.getRequirements().length <= 0) {
                return true;
            }
            for (DBEntry q : QuestDatabase.INSTANCE.bulkLookup(quest.getRequirements())) {
                if (q == null) {
                    return true;
                }
                if (!QuestCache.isQuestShown((IQuest)q.getValue(), uuid, player)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public class QResetTime
    implements Comparable<QResetTime> {
        public final int questID;
        public final long time;

        private QResetTime(int questID, long time) {
            this.questID = questID;
            this.time = time;
        }

        @Override
        public int compareTo(QResetTime o) {
            return Long.compare(o.time, this.time);
        }

        public boolean equals(Object o) {
            if (!(o instanceof QResetTime)) {
                return false;
            }
            return ((QResetTime)o).questID == this.questID;
        }
    }
}

