/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network;

import betterquesting.core.BetterQuesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public final class PacketAssembly {
    public static final PacketAssembly INSTANCE = new PacketAssembly();
    private final HashMap<UUID, byte[]> buffer = new HashMap();
    private byte[] serverBuf = null;
    private static final int bufSize = 20480;

    public List<NBTTagCompound> splitPacket(NBTTagCompound tags) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)tags, (OutputStream)baos);
            baos.flush();
            byte[] data = baos.toByteArray();
            baos.close();
            int req = MathHelper.func_76123_f((float)((float)data.length / 20480.0f));
            ArrayList<NBTTagCompound> pkts = new ArrayList<NBTTagCompound>(req);
            for (int p = 0; p < req; ++p) {
                int idx = p * 20480;
                int s = Math.min(data.length - idx, 20480);
                NBTTagCompound container = new NBTTagCompound();
                byte[] part = new byte[s];
                System.arraycopy(data, idx, part, 0, s);
                container.func_74768_a("size", data.length);
                container.func_74768_a("index", idx);
                container.func_74757_a("end", p == req - 1);
                container.func_74782_a("data", (NBTBase)new NBTTagByteArray(part));
                pkts.add(container);
            }
            return pkts;
        }
        catch (Exception e) {
            BetterQuesting.logger.error("Unable to split build packet!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public NBTTagCompound assemblePacket(UUID owner, NBTTagCompound tags) {
        int size = tags.func_74762_e("size");
        int index = tags.func_74762_e("index");
        boolean end = tags.func_74767_n("end");
        byte[] data = tags.func_74770_j("data");
        byte[] tmp = this.getBuffer(owner);
        if (tmp == null) {
            tmp = new byte[size];
            this.setBuffer(owner, tmp);
        } else if (tmp.length != size) {
            BetterQuesting.logger.error("Unexpected change in BQ packet byte length: " + size + " > " + tmp.length);
            this.clearBuffer(owner);
            return null;
        }
        System.arraycopy(data, 0, tmp, index, data.length);
        if (end) {
            this.clearBuffer(owner);
            try {
                return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(tmp));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to assemble BQ packet", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer(UUID owner) {
        if (owner == null) {
            return this.serverBuf;
        }
        HashMap<UUID, byte[]> hashMap = this.buffer;
        synchronized (hashMap) {
            return this.buffer.get(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(UUID owner, byte[] value) {
        if (owner == null) {
            this.serverBuf = value;
        } else {
            HashMap<UUID, byte[]> hashMap = this.buffer;
            synchronized (hashMap) {
                if (this.buffer.containsKey(owner)) {
                    throw new IllegalStateException("Attepted to start more than one BQ packet assembly for UUID " + owner.toString());
                }
                this.buffer.put(owner, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer(UUID owner) {
        if (owner == null) {
            this.serverBuf = null;
        } else {
            HashMap<UUID, byte[]> hashMap = this.buffer;
            synchronized (hashMap) {
                this.buffer.remove(owner);
            }
        }
    }
}

