/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.item;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.common.interfaces.IBeefDebuggableTile;
import erogenousbeef.bigreactors.common.item.ItemBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemBeefDebugTool
extends ItemBase {
    public ItemBeefDebugTool() {
        super("beefDebugTool");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List infoList, boolean advancedTooltips) {
        super.func_77624_a(stack, player, infoList, advancedTooltips);
        infoList.add("Rightclick a block to show debug info");
        infoList.add("");
        infoList.add(EnumChatFormatting.ITALIC + "Queries on server, by default.");
        infoList.add(EnumChatFormatting.GREEN + "Shift:" + EnumChatFormatting.GRAY + EnumChatFormatting.ITALIC + " Query on client");
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        String result;
        if (player.func_70093_af() != world.field_72995_K) {
            return false;
        }
        String clientOrServer = world.field_72995_K ? "CLIENT" : "SERVER";
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IBeefDebuggableTile && (result = ((IBeefDebuggableTile)te).getDebugInfo()) != null && !result.isEmpty()) {
            String[] results = result.split("\n");
            String initialMessage = String.format("[%s] Beef Debug Tool:", clientOrServer);
            player.func_145747_a((IChatComponent)new ChatComponentText(initialMessage));
            for (String r : results) {
                player.func_145747_a((IChatComponent)new ChatComponentText(r));
            }
            return true;
        }
        Block b = world.func_147439_a(x, y, z);
        if (b != null) {
            ItemStack blockStack = new ItemStack(b, 1, world.func_72805_g(x, y, z));
            String oreName = ItemHelper.oreProxy.getOreName(blockStack);
            player.func_145747_a((IChatComponent)new ChatComponentText(String.format("[%s] Canonical ore name for %s: %s", world.field_72995_K ? "CLIENT" : "SERVER", b.func_149739_a(), oreName)));
            ArrayList allOreNames = OreDictionaryArbiter.getAllOreNames((ItemStack)blockStack);
            if (allOreNames != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format("[%s] All ore names (%d):", clientOrServer, allOreNames.size())));
                for (String on : allOreNames) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(on));
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("getAllOreNames returned null"));
            }
        }
        return true;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }
}

