/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import erogenousbeef.bigreactors.common.BRLoader;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineFluidPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartStandard;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")})
public class BlockTurbinePart
extends BlockContainer
implements IPeripheralProvider {
    public static final int METADATA_HOUSING = 0;
    public static final int METADATA_CONTROLLER = 1;
    public static final int METADATA_POWERTAP = 2;
    public static final int METADATA_FLUIDPORT = 3;
    public static final int METADATA_BEARING = 4;
    public static final int METADATA_COMPUTERPORT = 5;
    private static final String[] _subBlocks = new String[]{"housing", "controller", "powerTap", "fluidPort", "bearing", "computerPort"};
    private static final int SUBICON_NONE = -1;
    private static final int SUBICON_HOUSING_FRAME_TOP = 0;
    private static final int SUBICON_HOUSING_FRAME_BOTTOM = 1;
    private static final int SUBICON_HOUSING_FRAME_LEFT = 2;
    private static final int SUBICON_HOUSING_FRAME_RIGHT = 3;
    private static final int SUBICON_HOUSING_FACE = 4;
    private static final int SUBICON_HOUSING_CORNER = 5;
    private static final int SUBICON_CONTROLLER_IDLE = 6;
    private static final int SUBICON_CONTROLLER_ACTIVE = 7;
    private static final int SUBICON_POWERTAP_ACTIVE = 8;
    private static final int SUBICON_FLUIDPORT_OUTPUT = 9;
    private static final String[] _subIconNames = new String[]{"housing.edge.0", "housing.edge.1", "housing.edge.2", "housing.edge.3", "housing.face", "housing.corner", "controller.idle", "controller.active", "powerTap.connected", "fluidPort.outlet"};
    private IIcon[] _icons = new IIcon[_subBlocks.length];
    private IIcon[] _subIcons = new IIcon[_subIconNames.length];

    public BlockTurbinePart(Material material) {
        super(material);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(2.0f);
        this.func_149663_c("blockTurbinePart");
        this.func_149658_d("bigreactors:blockTurbinePart");
        this.func_149647_a(BigReactors.TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        int i;
        for (i = 0; i < _subBlocks.length; ++i) {
            this._icons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a() + "." + _subBlocks[i]);
        }
        for (i = 0; i < this._subIcons.length; ++i) {
            this._subIcons[i] = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a() + "." + _subIconNames[i]);
        }
        this.field_149761_L = this._icons[0];
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        int metadata = blockAccess.func_72805_g(x, y, z);
        if (te instanceof TileEntityTurbinePartBase) {
            TileEntityTurbinePartBase part = (TileEntityTurbinePartBase)te;
            MultiblockTurbine turbine = part.getTurbine();
            if (metadata == 3) {
                if (te instanceof TileEntityTurbineFluidPort) {
                    if (turbine == null || !turbine.isAssembled() || part.getOutwardsDir().ordinal() == side) {
                        if (((TileEntityTurbineFluidPort)te).getFlowDirection() == TileEntityTurbineFluidPort.FluidFlow.Out) {
                            return this._subIcons[9];
                        }
                        return this._icons[3];
                    }
                    if (turbine.isAssembled() && part.getOutwardsDir().ordinal() != side) {
                        return this._subIcons[4];
                    }
                }
                return this.func_149691_a(side, metadata);
            }
            if (!part.isConnected() || turbine == null || !turbine.isAssembled()) {
                return this.func_149691_a(side, metadata);
            }
            int subIcon = -1;
            if (metadata == 0) {
                subIcon = this.getSubIconForHousing(blockAccess, x, y, z, turbine, side);
            } else if (part.getOutwardsDir().ordinal() == side) {
                if (metadata == 1) {
                    subIcon = turbine.getActive() ? 7 : 6;
                } else if (metadata == 2 && te instanceof TileEntityTurbinePowerTap && ((TileEntityTurbinePowerTap)te).isAttachedToPowerNetwork()) {
                    subIcon = 8;
                }
            } else {
                subIcon = 4;
            }
            if (subIcon == -1) {
                return this.func_149691_a(side, metadata);
            }
            return this._subIcons[subIcon];
        }
        return this.func_149691_a(side, metadata);
    }

    private int getSubIconForHousing(IBlockAccess blockAccess, int x, int y, int z, MultiblockTurbine turbine, int side) {
        CoordTriplet minCoord = turbine.getMinimumCoord();
        CoordTriplet maxCoord = turbine.getMaximumCoord();
        if (minCoord == null || maxCoord == null) {
            return -1;
        }
        int extremes = 0;
        boolean zExtreme = false;
        boolean yExtreme = false;
        boolean xExtreme = false;
        if (x == minCoord.x) {
            ++extremes;
            xExtreme = true;
        }
        if (y == minCoord.y) {
            ++extremes;
            yExtreme = true;
        }
        if (z == minCoord.z) {
            ++extremes;
            zExtreme = true;
        }
        if (x == maxCoord.x) {
            ++extremes;
            xExtreme = true;
        }
        if (y == maxCoord.y) {
            ++extremes;
            yExtreme = true;
        }
        if (z == maxCoord.z) {
            ++extremes;
            zExtreme = true;
        }
        if (extremes >= 3) {
            return 5;
        }
        if (extremes <= 0) {
            return -1;
        }
        if (extremes == 1) {
            return 4;
        }
        ForgeDirection[] dirsToCheck = StaticUtils.neighborsBySide[side];
        Block myBlock = blockAccess.func_147439_a(x, y, z);
        int iconIdx = -1;
        for (int i = 0; i < dirsToCheck.length; ++i) {
            ForgeDirection dir = dirsToCheck[i];
            Block neighborBlock = blockAccess.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (neighborBlock == myBlock || neighborBlock == BigReactors.blockMultiblockGlass || BigReactors.blockMultiblockCreativePart == null || neighborBlock == BigReactors.blockMultiblockCreativePart) continue;
            iconIdx = i;
            break;
        }
        return iconIdx + 0;
    }

    public IIcon func_149691_a(int side, int metadata) {
        metadata = Math.max(0, Math.min(metadata, _subBlocks.length - 1));
        return this._icons[metadata];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata == 2) {
            return new TileEntityTurbinePowerTap();
        }
        if (metadata == 3) {
            return new TileEntityTurbineFluidPort();
        }
        if (metadata == 4) {
            return new TileEntityTurbineRotorBearing();
        }
        if (metadata == 5) {
            return new TileEntityTurbineComputerPort();
        }
        return new TileEntityTurbinePartStandard();
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        TileEntity te = StaticUtils.TE.getTileEntityUnsafe(world, x, y, z);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborBlockChange(world, x, y, z, neighborBlock);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        TileEntity te = StaticUtils.TE.getTileEntityUnsafe(world, x, y, z);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborTileChange(world, x, y, z, neighborX, neighborY, neighborZ);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity te;
        if (player.func_70093_af()) {
            return false;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 3 && StaticUtils.Inventory.isPlayerHoldingWrench(player) && (te = world.func_147438_o(x, y, z)) instanceof TileEntityTurbineFluidPort) {
            TileEntityTurbineFluidPort fluidPort;
            TileEntityTurbineFluidPort.FluidFlow flow = (fluidPort = (TileEntityTurbineFluidPort)te).getFlowDirection();
            fluidPort.setFluidFlowDirection(flow == TileEntityTurbineFluidPort.FluidFlow.In ? TileEntityTurbineFluidPort.FluidFlow.Out : TileEntityTurbineFluidPort.FluidFlow.In, true);
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_71045_bC() == null && (te = world.func_147438_o(x, y, z)) instanceof IMultiblockPart) {
            MultiblockControllerBase controller = ((IMultiblockPart)te).getMultiblockController();
            if (controller == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format("SERIOUS ERROR - server part @ %d, %d, %d has no controller!", x, y, z)));
            } else {
                MultiblockValidationException e = controller.getLastValidationException();
                if (e != null) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(e.getMessage() + " - controller " + Integer.toString(controller.hashCode())));
                    return true;
                }
            }
        }
        if (metadata != 1) {
            return false;
        }
        te = world.func_147438_o(x, y, z);
        if (!(te instanceof IMultiblockPart)) {
            return false;
        }
        IMultiblockPart part = (IMultiblockPart)te;
        if (!part.isConnected() || !part.getMultiblockController().isAssembled()) {
            return false;
        }
        player.openGui((Object)BRLoader.instance, 0, world, x, y, z);
        return true;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public ItemStack getItemStack(String name) {
        int metadata = -1;
        for (int i = 0; i < _subBlocks.length; ++i) {
            if (!_subBlocks[i].equals(name)) continue;
            metadata = i;
            break;
        }
        if (metadata < 0) {
            throw new IllegalArgumentException("Unable to find a block with the name " + name);
        }
        return new ItemStack((Block)this, 1, metadata);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < _subBlocks.length; ++i) {
            par3List.add(new ItemStack((Block)this, 1, i));
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int amountToDrop = world.field_73012_v.nextInt(21) + 10;
                    if (amountToDrop > itemstack.field_77994_a) {
                        amountToDrop = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= amountToDrop;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.func_77973_b(), amountToDrop, itemstack.func_77960_j()));
                    if (itemstack.func_77978_p() != null) {
                        entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p());
                    }
                    float motionMultiplier = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random par5Random) {
        TileEntityTurbinePartStandard bearing;
        MultiblockTurbine turbine;
        TileEntity te;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 4 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityTurbinePartStandard && (turbine = (bearing = (TileEntityTurbinePartStandard)te).getTurbine()) != null && turbine.getActive()) {
            int numParticles = Math.min(20, Math.max(1, turbine.getFluidConsumedLastTick() / 40));
            ForgeDirection inwardsDir = bearing.getOutwardsDir().getOpposite();
            CoordTriplet minCoord = turbine.getMinimumCoord();
            CoordTriplet maxCoord = turbine.getMaximumCoord();
            ++minCoord.x;
            ++minCoord.y;
            ++minCoord.z;
            --maxCoord.x;
            --maxCoord.y;
            --maxCoord.z;
            if (inwardsDir.offsetX != 0) {
                minCoord.x = maxCoord.x = bearing.field_145851_c + inwardsDir.offsetX;
            } else if (inwardsDir.offsetY != 0) {
                minCoord.y = maxCoord.y = bearing.field_145848_d + inwardsDir.offsetY;
            } else {
                minCoord.z = maxCoord.z = bearing.field_145849_e + inwardsDir.offsetZ;
            }
            for (int i = 0; i < numParticles; ++i) {
                double particleX = (float)minCoord.x + par5Random.nextFloat() * (float)(maxCoord.x - minCoord.x + 1);
                double particleY = (float)minCoord.y + par5Random.nextFloat() * (float)(maxCoord.y - minCoord.y + 1);
                double particleZ = (float)minCoord.z + par5Random.nextFloat() * (float)(maxCoord.z - minCoord.z + 1);
                world.func_72869_a(BigReactors.isValentinesDay ? "heart" : "cloud", particleX, particleY, particleZ, (double)(par5Random.nextFloat() * (float)inwardsDir.offsetX), (double)(par5Random.nextFloat() * (float)inwardsDir.offsetY), (double)(par5Random.nextFloat() * (float)inwardsDir.offsetZ));
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TileEntityTurbineRotorBearing bearing;
        TileEntity te;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 4 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityTurbineRotorBearing && (bearing = (TileEntityTurbineRotorBearing)te).isConnected() && bearing.getTurbine().getActive()) {
            return bearing.getAABB();
        }
        return super.func_149668_a(world, x, y, z);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityTurbineComputerPort) {
            return (IPeripheral)te;
        }
        return null;
    }
}

