/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.core.block.TileCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import erogenousbeef.bigreactors.common.interfaces.IBeefReconfigurableSides;
import erogenousbeef.bigreactors.common.interfaces.IWrenchable;
import erogenousbeef.bigreactors.gui.IBeefGuiEntity;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.message.DeviceUpdateExposureMessage;
import erogenousbeef.bigreactors.net.message.DeviceUpdateMessage;
import erogenousbeef.bigreactors.net.message.DeviceUpdateRotationMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityBeefBase
extends TileCoFHBase
implements IBeefGuiEntity,
IBeefReconfigurableSides,
IReconfigurableFacing,
IWrenchable {
    private Set<EntityPlayer> updatePlayers;
    private int ticksSinceLastUpdate;
    private static final int ticksBetweenUpdates = 3;
    protected static final int SIDE_UNEXPOSED = -1;
    protected static final int[] kEmptyIntArray = new int[0];
    protected int facing = ForgeDirection.NORTH.ordinal();
    int[] exposures = new int[6];

    public TileEntityBeefBase() {
        for (int i = 0; i < this.exposures.length; ++i) {
            this.exposures[i] = -1;
        }
        this.ticksSinceLastUpdate = 0;
        this.updatePlayers = new HashSet<EntityPlayer>();
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean setFacing(int newFacing) {
        if (this.facing == newFacing) {
            return false;
        }
        if (!(this.allowYAxisFacing() || newFacing != ForgeDirection.UP.ordinal() && newFacing != ForgeDirection.DOWN.ordinal())) {
            return false;
        }
        this.facing = newFacing;
        if (!this.field_145850_b.field_72995_K) {
            CommonPacketHandler.INSTANCE.sendToAllAround((IMessage)new DeviceUpdateRotationMessage(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            this.markChunkDirty();
        }
        this.callNeighborBlockChange();
        return true;
    }

    public int getRotatedSide(int side) {
        return BlockHelper.ICON_ROTATION_MAP[this.facing][side];
    }

    public boolean rotateBlock() {
        return this.setFacing(BlockHelper.SIDE_LEFT[this.facing]);
    }

    @Override
    public boolean onWrench(EntityPlayer player, int hitSide) {
        return this.rotateBlock();
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.facing = tag.func_74764_b("facing") ? Math.max(0, Math.min(5, tag.func_74762_e("facing"))) : 2;
        if (tag.func_74764_b("exposures")) {
            int[] tagExposures = tag.func_74759_k("exposures");
            assert (tagExposures.length == this.exposures.length);
            System.arraycopy(tagExposures, 0, this.exposures, 0, this.exposures.length);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("facing", this.facing);
        tag.func_74783_a("exposures", this.exposures);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tagCompound);
    }

    public void onDataPacket(NetworkManager network, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.updatePlayers.size() > 0) {
            ++this.ticksSinceLastUpdate;
            if (this.ticksSinceLastUpdate >= 3) {
                this.sendUpdatePacket();
                this.ticksSinceLastUpdate = 0;
            }
        }
    }

    public abstract boolean isActive();

    @Override
    public void beginUpdatingPlayer(EntityPlayer player) {
        this.updatePlayers.add(player);
        this.sendUpdatePacketToClient(player);
    }

    @Override
    public void stopUpdatingPlayer(EntityPlayer player) {
        this.updatePlayers.remove(player);
    }

    protected IMessage getUpdatePacket() {
        NBTTagCompound childData = new NBTTagCompound();
        this.onSendUpdate(childData);
        return new DeviceUpdateMessage(this.field_145851_c, this.field_145848_d, this.field_145849_e, childData);
    }

    private void sendUpdatePacketToClient(EntityPlayer recipient) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        CommonPacketHandler.INSTANCE.sendTo(this.getUpdatePacket(), (EntityPlayerMP)recipient);
    }

    private void sendUpdatePacket() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updatePlayers.size() <= 0) {
            return;
        }
        for (EntityPlayer player : this.updatePlayers) {
            CommonPacketHandler.INSTANCE.sendTo(this.getUpdatePacket(), (EntityPlayerMP)player);
        }
    }

    public boolean setSide(int side, int config) {
        int rotatedSide = this.getRotatedSide(side);
        int numConfig = this.getNumConfig(side);
        if (config >= numConfig || config < -1) {
            config = -1;
        }
        this.exposures[rotatedSide] = config;
        this.sendExposureUpdate();
        return true;
    }

    protected int getExposure(int worldSide) {
        return this.exposures[this.getRotatedSide(worldSide)];
    }

    public void setSides(int[] newExposures) {
        assert (newExposures.length == this.exposures.length);
        System.arraycopy(newExposures, 0, this.exposures, 0, newExposures.length);
        this.sendExposureUpdate();
    }

    public boolean incrSide(int side) {
        return this.changeSide(side, 1);
    }

    public boolean decrSide(int side) {
        return this.changeSide(side, -1);
    }

    private boolean changeSide(int side, int amount) {
        int rotatedSide = this.getRotatedSide(side);
        int numConfig = this.getNumConfig(side);
        if (numConfig <= 0) {
            return false;
        }
        int newConfig = this.exposures[rotatedSide] + amount;
        if (newConfig >= numConfig) {
            newConfig = -1;
        }
        return this.setSide(side, newConfig);
    }

    public boolean resetSides() {
        boolean changed = false;
        for (int i = 0; i < this.exposures.length; ++i) {
            if (this.exposures[i] == -1) continue;
            changed = true;
            this.exposures[i] = -1;
        }
        if (changed) {
            this.sendExposureUpdate();
        }
        return true;
    }

    private void sendExposureUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            CommonPacketHandler.INSTANCE.sendToAllAround((IMessage)new DeviceUpdateExposureMessage(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.exposures), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            this.markChunkDirty();
        } else {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.callNeighborTileChange();
        this.callNeighborBlockChange();
    }

    protected void onSendUpdate(NBTTagCompound updateTag) {
    }

    public void onReceiveUpdate(NBTTagCompound updateTag) {
    }

    public String getName() {
        return this.func_145838_q().func_149739_a();
    }

    public int getType() {
        return this.func_145832_p();
    }
}

