/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common;

import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import com.arc.bloodarsenal.common.BloodArsenal;
import com.arc.bloodarsenal.common.BloodArsenalConfig;
import com.arc.bloodarsenal.common.items.ModItems;
import com.arc.bloodarsenal.common.items.armor.GlassArmor;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class BloodArsenalEventHooks {
    private Random rand = new Random();

    @SubscribeEvent
    public void onEntityDamaged(LivingAttackEvent event) {
        EntityLivingBase entityAttacked = event.entityLiving;
        Entity entityAttacking = event.source.func_76364_f();
        float damageDone = event.ammount;
        if (entityAttacking != null && entityAttacked != null) {
            if (entityAttacking instanceof EntityLivingBase && ((EntityLivingBase)entityAttacking).func_70644_a(BloodArsenal.vampiricAura)) {
                float drainedHealth = damageDone / 4.0f;
                ((EntityLivingBase)entityAttacking).func_70606_j(((EntityLivingBase)entityAttacking).func_110143_aJ() + drainedHealth);
            }
            if (entityAttacked instanceof EntityPlayer) {
                if (entityAttacked.func_70644_a(BloodArsenal.swimming) && entityAttacked.func_70055_a(Material.field_151587_i) && event.source.func_76347_k()) {
                    event.setCanceled(true);
                }
                EntityPlayerMP player = (EntityPlayerMP)entityAttacked;
                if (player.field_71071_by.field_70460_b != null) {
                    for (int i = 0; i < 4; ++i) {
                        ItemStack armorStack = player.field_71071_by.field_70460_b[3 - i];
                        if (armorStack == null || !(armorStack.func_77973_b() instanceof GlassArmor) || !(entityAttacking instanceof EntityLivingBase)) continue;
                        ((EntityLivingBase)entityAttacking).func_70690_d(new PotionEffect(BloodArsenalConfig.bleedingID, this.rand.nextInt(3) * 20, this.rand.nextInt(1)));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity != null) {
            int amplifier;
            if (entity.func_70644_a(BloodArsenal.bleeding)) {
                amplifier = entity.func_70660_b(BloodArsenal.bleeding).func_76458_c();
                int duration = entity.func_70660_b(BloodArsenal.bleeding).func_76459_b();
                int damage = this.rand.nextInt(2) * (amplifier + 1) + this.rand.nextInt(2);
                entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, duration, 1));
                if (entity.field_70170_p.func_72820_D() % (long)(60 / (amplifier + 1)) == 0L) {
                    entity.func_70097_a(BloodArsenal.deathFromBlood, (float)damage);
                    entity.field_70172_ad = Math.min(entity.field_70172_ad, 60 / (amplifier + 1));
                    entity.func_70030_z();
                }
            }
            if (!entity.field_70170_p.field_72995_K && entity.func_70644_a(BloodArsenal.soulBurn)) {
                amplifier = entity.func_70660_b(BloodArsenal.soulBurn).func_76458_c();
                entity.func_70015_d(2);
                if (entity instanceof EntityPlayer && entity.field_70170_p.func_72820_D() % (long)(10 / (amplifier + 1)) == 0L) {
                    WorldServer worldSave = MinecraftServer.func_71276_C().field_71305_c[0];
                    String owner = entity.func_70005_c_();
                    LifeEssenceNetwork data = (LifeEssenceNetwork)worldSave.func_72943_a(LifeEssenceNetwork.class, owner);
                    if (data == null) {
                        data = new LifeEssenceNetwork(owner);
                        worldSave.func_72823_a(owner, (WorldSavedData)data);
                    }
                    int lpToMinus = 1000 * (2 ^ amplifier + 1);
                    SoulNetworkHandler.syphonAndDamageFromNetwork((String)owner, (EntityPlayer)((EntityPlayer)entity), (int)lpToMinus);
                }
            }
            if (entity instanceof EntityPlayer && entity.func_70644_a(BloodArsenal.swimming) && (entity.func_70090_H() || entity.func_70055_a(Material.field_151587_i))) {
                entity.func_70050_g(300);
                entity.field_70159_w *= 1.2;
                if (entity.field_70181_x > 0.0) {
                    entity.field_70181_x *= 1.2;
                }
                entity.field_70179_y *= 1.2;
                double maxSpeed = 0.2;
                if (entity.field_70159_w > maxSpeed) {
                    entity.field_70159_w = maxSpeed;
                } else if (entity.field_70159_w < -maxSpeed) {
                    entity.field_70159_w = -maxSpeed;
                }
                if (entity.field_70181_x > maxSpeed) {
                    entity.field_70181_x = maxSpeed;
                }
                if (entity.field_70179_y > maxSpeed) {
                    entity.field_70179_y = maxSpeed;
                } else if (entity.field_70179_y < -maxSpeed) {
                    entity.field_70179_y = -maxSpeed;
                }
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        EntityLivingBase entityLiving = event.entityLiving;
        if (entityLiving instanceof EntityPlayer && entityLiving.func_70644_a(BloodArsenal.swimming) && (entityLiving.func_70090_H() || entityLiving.func_70055_a(Material.field_151587_i))) {
            event.newSpeed = 1.75f;
        }
    }

    @SubscribeEvent
    public void harvestEvent(BlockEvent.HarvestDropsEvent event) {
        if (GameRegistry.findItem((String)"BloodArsenal", (String)"glass_shard") != null) {
            Block block = event.block;
            EntityPlayer player = event.harvester;
            Random random = new Random();
            if (player instanceof EntityPlayerMP && !event.world.field_72995_K && !event.isSilkTouching && block instanceof BlockGlass) {
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Items.field_151145_ak) {
                    event.drops.add(new ItemStack(ModItems.glass_shard));
                    if (random.nextInt() + 5 < 8) {
                        event.drops.add(new ItemStack(ModItems.glass_shard));
                    }
                    event.dropChance = 0.25f;
                    if (BloodArsenalConfig.isGlassDangerous && random.nextInt(5) > 3) {
                        player.func_70690_d(new PotionEffect(BloodArsenal.bleeding.field_76415_H, 80, random.nextInt(2)));
                    }
                } else if (BloodArsenalConfig.isGlassDangerous && random.nextInt(3) == 2) {
                    player.func_70690_d(new PotionEffect(BloodArsenal.bleeding.field_76415_H, 160, random.nextInt(3)));
                }
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("BloodArsenal")) {
            BloodArsenalConfig.syncConfig();
            BloodArsenal.logger.info("Refreshing configuration file");
        }
    }
}

