/*
 * Decompiled with CFR 0.152.
 */
package team.luxinfine.botania;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import team.luxinfine.botania.EventHandlers;
import vazkii.botania.api.mana.spark.ISparkEntity;

public class ModUtils {
    private static final DecimalFormat groupPattern = new DecimalFormat("###,###");

    public static String formatInt(int count) {
        return groupPattern.format(count);
    }

    public static List<ISparkEntity> getSparks(World world, double x, double y, double z, int radius) {
        ArrayList<ISparkEntity> sparks = new ArrayList<ISparkEntity>();
        Iterator<Entity> i = EventHandlers.sparks.iterator();
        while (i.hasNext()) {
            Entity spark = i.next();
            if (spark.func_70089_S()) {
                if (spark.field_70170_p != world || !(spark.func_70011_f(x, y, z) <= (double)radius)) continue;
                sparks.add((ISparkEntity)spark);
                continue;
            }
            i.remove();
        }
        return sparks;
    }

    public static void drawModelWithoutCompilation(ModelRenderer model, float f) {
        int i;
        if (model.field_78807_k || !model.field_78806_j) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        float translateX = model.field_82906_o + model.field_78800_c * f;
        float translateY = model.field_82908_p + model.field_78797_d * f;
        float translateZ = model.field_82907_q + model.field_78798_e * f;
        float rotationAngleX = model.field_78795_f * 57.295776f;
        float rotationAngleY = model.field_78796_g * 57.295776f;
        float rotationAngleZ = model.field_78808_h * 57.295776f;
        if (translateX != 0.0f || translateY != 0.0f || translateZ != 0.0f) {
            GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
        }
        if (rotationAngleZ != 0.0f) {
            GL11.glRotatef((float)rotationAngleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (rotationAngleY != 0.0f) {
            GL11.glRotatef((float)rotationAngleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotationAngleX != 0.0f) {
            GL11.glRotatef((float)rotationAngleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        for (i = 0; i < model.field_78804_l.size(); ++i) {
            ((ModelBox)model.field_78804_l.get(i)).func_78245_a(tessellator, f);
        }
        if (model.field_78805_m != null) {
            for (i = 0; i < model.field_78805_m.size(); ++i) {
                ModUtils.drawModelWithoutCompilation((ModelRenderer)model.field_78805_m.get(i), f);
            }
        }
        if (rotationAngleZ != 0.0f) {
            GL11.glRotatef((float)(-rotationAngleZ), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (rotationAngleY != 0.0f) {
            GL11.glRotatef((float)(-rotationAngleY), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotationAngleX != 0.0f) {
            GL11.glRotatef((float)(-rotationAngleX), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (translateX != 0.0f || translateY != 0.0f || translateZ != 0.0f) {
            GL11.glTranslatef((float)(-translateX), (float)(-translateY), (float)(-translateZ));
        }
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        groupPattern.setDecimalFormatSymbols(symbols);
    }
}

