/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.asm.ASMCore;
import cofh.core.CoFHProps;
import cofh.core.Proxy;
import cofh.core.RegistryEnderAttuned;
import cofh.core.RegistrySocial;
import cofh.core.command.CommandFriend;
import cofh.core.command.CommandHandler;
import cofh.core.enchantment.CoFHEnchantment;
import cofh.core.entity.DropHandler;
import cofh.core.gui.GuiHandler;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketCore;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketSocial;
import cofh.core.util.ConfigHandler;
import cofh.core.util.FMLEventHandler;
import cofh.core.util.IBakeable;
import cofh.core.util.crafting.RecipeAugmentable;
import cofh.core.util.crafting.RecipeSecure;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.core.util.crafting.RecipeUpgradeOverride;
import cofh.core.util.energy.FurnaceFuelHandler;
import cofh.core.util.fluid.BucketHandler;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.core.world.FeatureParser;
import cofh.core.world.WorldHandler;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.mod.BaseMod;
import cofh.mod.updater.UpdateManager;
import com.gamerforea.cofh.EventConfig;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="CoFHCore", name="CoFH Core", version="1.7.10R3.1.4", dependencies="required-after:Forge@[10.13.4.1448,10.14);", guiFactory="cofh.core.gui.GuiConfigCoreFactory", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})
public class CoFHCore
extends BaseMod {
    public static final String modId = "CoFHCore";
    public static final String modName = "CoFH Core";
    public static final String version = "1.7.10R3.1.4";
    public static final String version_max = "1.7.10R3.2.0";
    public static final String dependencies = "required-after:Forge@[10.13.4.1448,10.14);";
    public static final String modGuiFactory = "cofh.core.gui.GuiConfigCoreFactory";
    public static final String version_group = "required-after:CoFHCore@[1.7.10R3.1.4,1.7.10R3.2.0);";
    public static final String releaseURL = "https://raw.github.com/CoFH/VERSION/master/CoFHCore";
    @Mod.Instance(value="CoFHCore")
    public static CoFHCore instance;
    @SidedProxy(clientSide="cofh.core.ProxyClient", serverSide="cofh.core.Proxy")
    public static Proxy proxy;
    public static final Logger log;
    public static final ConfigHandler configCore;
    public static final ConfigHandler configLoot;
    public static final ConfigHandler configClient;
    public static final GuiHandler guiHandler;
    public static MinecraftServer server;
    private final ArrayList<IBakeable> oven = new ArrayList();

    public static void registerBakeable(IBakeable var0) {
        CoFHCore.instance.oven.add(var0);
    }

    public CoFHCore() {
        super(log);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent var1) {
        CoFHProps.configDir = var1.getModConfigurationDirectory();
        UpdateManager.registerUpdater(new UpdateManager(this, releaseURL, "http://teamcofh.com/downloads/"));
        configCore.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/core/common.cfg"), true));
        configClient.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/core/client.cfg"), true));
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        proxy.preInit();
        this.moduleCore();
        this.moduleLoot();
        FeatureParser.initialize();
        WorldHandler.initialize();
        FMLEventHandler.initialize();
        BucketHandler.initialize();
        FurnaceFuelHandler.initialize();
        PacketHandler.instance.initialize();
        RecipeSorter.register((String)"cofh:augment", RecipeAugmentable.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
        RecipeSorter.register((String)"cofh:secure", RecipeSecure.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:cofh:upgrade");
        RecipeSorter.register((String)"cofh:upgrade", RecipeUpgrade.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
        RecipeSorter.register((String)"cofh:upgradeoverride", RecipeUpgradeOverride.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:forge:shapedore");
        this.registerOreDictionaryEntries();
        EventConfig.init();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent var1) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)guiHandler);
        CommandHandler.registerSubCommand(CommandFriend.instance);
        SecurityHelper.setup();
        PacketCore.initialize();
        PacketSocial.initialize();
        RegistrySocial.initialize();
        RegistryEnderAttuned.initialize();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent var1) {
        OreDictionaryArbiter.initialize();
        CoFHEnchantment.postInit();
        proxy.registerKeyBinds();
        proxy.registerRenderInformation();
        proxy.registerTickHandlers();
        proxy.registerPacketInformation();
        PacketHandler.instance.postInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent var1) {
        configCore.cleanUp(false, true);
        try {
            FeatureParser.parseGenerationFile();
        }
        catch (Throwable var3) {
            var3.printStackTrace();
        }
        ASMCore.onGameLoaded();
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent var1) {
        RegistryEnderAttuned.createClientRegistry();
        RegistryEnderAttuned.createServerRegistry();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent var1) {
        OreDictionaryArbiter.initialize();
        CommandHandler.initCommands(var1);
        server = var1.getServer();
        for (IBakeable var3 : this.oven) {
            var3.bake();
        }
    }

    public void handleConfigSync(PacketCoFHBase var1) {
        FMLEventHandler.instance.handleIdMappingEvent(null);
        RegistryEnderAttuned.createClientRegistry();
    }

    public PacketCoFHBase getConfigSync() {
        PacketCoFHBase var1 = PacketCore.getPacket(PacketCore.PacketTypes.CONFIG_SYNC);
        return var1;
    }

    public void registerOreDictionaryEntries() {
        this.registerOreDictionaryEntry("blockCloth", new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        this.registerOreDictionaryEntry("coal", new ItemStack(Items.field_151044_h, 1, 0));
        this.registerOreDictionaryEntry("charcoal", new ItemStack(Items.field_151044_h, 1, 1));
    }

    private boolean registerOreDictionaryEntry(String var1, ItemStack var2) {
        if (OreDictionary.getOres((String)var1).isEmpty()) {
            OreDictionary.registerOre((String)var1, (ItemStack)var2);
            return true;
        }
        return false;
    }

    private boolean moduleCore() {
        String var2 = "General";
        String var1 = "Set to TRUE to be informed of non-critical updates. You will still receive critical update notifications.";
        CoFHProps.enableUpdateNotice = configCore.get(var2, "EnableUpdateNotifications", true, var1);
        var1 = "Set to TRUE for this to log when a block is dismantled.";
        CoFHProps.enableDismantleLogging = configCore.get(var2, "EnableDismantleLogging", false, var1);
        var1 = "Set to TRUE to display death messages for any named entity.";
        CoFHProps.enableLivingEntityDeathMessages = configCore.get(var2, "EnableGenericDeathMessage", true, var1);
        var1 = "Set to FALSE to disable items on the ground from trying to stack. This can improve server performance.";
        CoFHProps.enableItemStacking = configCore.get(var2, "EnableItemStacking", true, var1);
        var2 = "Holiday";
        var1 = "Set this to TRUE to disable April Foolishness.";
        CoFHProps.holidayAprilFools = !configCore.get(var2, "IHateApril", false, var1);
        var1 = "Set this to TRUE to disable Christmas cheer. Scrooge. :(";
        CoFHProps.holidayChristmas = !configCore.get(var2, "HoHoNo", false, var1);
        var2 = "Security";
        var1 = "Set to TRUE to allow for Server Ops to access 'secure' blocks. Your players will be warned upon server connection.";
        CoFHProps.enableOpSecureAccess = configCore.get(var2, "OpsCanAccessSecureBlocks", false, var1);
        var2 = "World.Tweaks";
        var1 = "Set this to a value > 1 to make trees grow more infrequently. Rate is 1 in N. Example: If this value is set to 3, trees will take 3x the time to grow, on average.";
        CoFHProps.treeGrowthChance = configCore.get(var2, "TreeGrowthChance", 1, var1);
        configCore.save();
        return true;
    }

    private boolean moduleLoot() {
        configLoot.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/core/loot.cfg"), true));
        String var2 = "General";
        String var1 = "Set to false to disable this entire module.";
        boolean var3 = configLoot.get(var2, "EnableModule", true, var1);
        if (!var3) {
            configLoot.save();
            return false;
        }
        var2 = "Heads";
        var1 = "If enabled, mobs only drop heads when killed by players.";
        DropHandler.mobPvEOnly = configLoot.get(var2, "MobsDropOnPvEOnly", DropHandler.mobPvEOnly, var1);
        var1 = "If enabled, players only drop heads when killed by other players.";
        DropHandler.playerPvPOnly = configLoot.get(var2, "PlayersDropOnPvPOnly", DropHandler.playerPvPOnly, var1);
        var2 = "Heads.Players";
        DropHandler.playersEnabled = configLoot.get(var2, "Enabled", DropHandler.playersEnabled);
        DropHandler.playerChance = configLoot.get(var2, "Chance", DropHandler.playerChance);
        var2 = "Heads.Creepers";
        DropHandler.creeperEnabled = configLoot.get(var2, "Enabled", DropHandler.creeperEnabled);
        DropHandler.creeperChance = configLoot.get(var2, "Chance", DropHandler.creeperChance);
        var2 = "Heads.Skeletons";
        DropHandler.skeletonEnabled = configLoot.get(var2, "Enabled", DropHandler.skeletonEnabled);
        DropHandler.skeletonChance = configLoot.get(var2, "Chance", DropHandler.skeletonChance);
        var2 = "Heads.WitherSkeletons";
        DropHandler.skeletonEnabled = configLoot.get(var2, "Enabled", DropHandler.witherSkeletonEnabled);
        DropHandler.witherSkeletonChance = configLoot.get(var2, "Chance", DropHandler.witherSkeletonChance);
        var2 = "Heads.Zombies";
        DropHandler.zombieEnabled = configLoot.get(var2, "Enabled", DropHandler.zombieEnabled);
        DropHandler.zombieChance = configLoot.get(var2, "Chance", DropHandler.zombieChance);
        configLoot.save();
        MinecraftForge.EVENT_BUS.register((Object)DropHandler.instance);
        return true;
    }

    @Override
    public String getModId() {
        return modId;
    }

    @Override
    protected String getAssetDir() {
        return "cofh";
    }

    @Override
    public String getModName() {
        return modName;
    }

    @Override
    public String getModVersion() {
        return version;
    }

    static {
        log = LogManager.getLogger((String)modId);
        configCore = new ConfigHandler(version);
        configLoot = new ConfigHandler(version);
        configClient = new ConfigHandler(version);
        guiHandler = new GuiHandler();
    }
}

