/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import java.util.Set;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    Configuration modConfiguration;
    String modVersion;

    public ConfigHandler(String string) {
        this.modVersion = string;
    }

    public ConfigHandler setConfiguration(Configuration configuration) {
        this.modConfiguration = configuration;
        this.modConfiguration.load();
        return this;
    }

    public Configuration getConfiguration() {
        return this.modConfiguration;
    }

    public String getVersion() {
        return this.modVersion;
    }

    public String getConfigVersion() {
        return this.get("Version", "Identifier", this.modVersion);
    }

    public boolean isOldConfig() {
        return !this.getConfigVersion().equals(this.modVersion);
    }

    public void save() {
        this.modConfiguration.save();
    }

    public double get(String string, String string2, double d) {
        return this.modConfiguration.get(string, string2, d, null).getDouble(0.0);
    }

    public double get(String string, String string2, double d, String string3) {
        return this.modConfiguration.get(string, string2, d, string3).getDouble(0.0);
    }

    public int get(String string, String string2, int n) {
        return this.modConfiguration.get(string, string2, n, null).getInt();
    }

    public int get(String string, String string2, int n, String string3) {
        return this.modConfiguration.get(string, string2, n, string3).getInt();
    }

    public boolean get(String string, String string2, boolean bl) {
        return this.modConfiguration.get(string, string2, bl, null).getBoolean(bl);
    }

    public boolean get(String string, String string2, boolean bl, String string3) {
        return this.modConfiguration.get(string, string2, bl, string3).getBoolean(bl);
    }

    public String get(String string, String string2, String string3) {
        return this.modConfiguration.get(string, string2, string3, null).getString();
    }

    public String get(String string, String string2, String string3, String string4) {
        return this.modConfiguration.get(string, string2, string3, string4).getString();
    }

    public void set(String string, String string2, double d) {
        this.getProperty(string, string2, d).set(d);
    }

    public void set(String string, String string2, int n) {
        this.getProperty(string, string2, n).set(n);
    }

    public void set(String string, String string2, boolean bl) {
        this.getProperty(string, string2, bl).set(bl);
    }

    public void set(String string, String string2, String string3) {
        this.getProperty(string, string2, string3).set(string3);
    }

    public Property getProperty(String string, String string2, double d) {
        return this.modConfiguration.get(string, string2, d);
    }

    public Property getProperty(String string, String string2, int n) {
        return this.modConfiguration.get(string, string2, n);
    }

    public Property getProperty(String string, String string2, boolean bl) {
        return this.modConfiguration.get(string, string2, bl);
    }

    public Property getProperty(String string, String string2, String string3) {
        return this.modConfiguration.get(string, string2, string3);
    }

    public ConfigCategory getCategory(String string) {
        return this.modConfiguration.getCategory(string);
    }

    public Set<String> getCategoryNames() {
        return this.modConfiguration.getCategoryNames();
    }

    public Set<String> getCategoryKeys(String string) {
        return this.modConfiguration.getCategory(string).getValues().keySet();
    }

    public boolean hasCategory(String string) {
        return this.modConfiguration.hasCategory(string);
    }

    public boolean hasKey(String string, String string2) {
        return this.modConfiguration.hasKey(string, string2);
    }

    public boolean copyProperty(String string, String string2, String string3, String string4, boolean bl) {
        if (this.modConfiguration.hasKey(string, string2)) {
            Property property = this.modConfiguration.getCategory(string).get(string2);
            if (property.isIntValue()) {
                int n = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getInt();
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, n);
            } else if (property.isBooleanValue()) {
                boolean bl2 = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getBoolean(false);
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, bl2);
            } else if (property.isDoubleValue()) {
                double d = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getDouble(0.0);
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, d);
            } else {
                String string5 = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getString();
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, string5);
            }
            return true;
        }
        return false;
    }

    public boolean renameProperty(String string, String string2, String string3, String string4, boolean bl) {
        if (this.modConfiguration.hasKey(string, string2)) {
            Property property = this.modConfiguration.getCategory(string).get(string2);
            if (property.isIntValue()) {
                int n = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getInt();
                this.removeProperty(string, string2);
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, n);
            } else if (property.isBooleanValue()) {
                boolean bl2 = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getBoolean(false);
                this.removeProperty(string, string2);
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, bl2);
            } else if (property.isDoubleValue()) {
                double d = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getDouble(0.0);
                this.removeProperty(string, string2);
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, d);
            } else {
                String string5 = ((Property)this.modConfiguration.getCategory(string).getValues().get(string2)).getString();
                this.removeProperty(string, string2);
                if (bl) {
                    this.removeProperty(string3, string4);
                }
                this.modConfiguration.get(string3, string4, string5);
            }
            return true;
        }
        return false;
    }

    public boolean removeProperty(String string, String string2) {
        if (!this.modConfiguration.hasKey(string, string2)) {
            return false;
        }
        this.modConfiguration.getCategory(string).remove((Object)string2);
        return true;
    }

    public boolean renameCategory(String string, String string2) {
        if (!this.modConfiguration.hasCategory(string)) {
            return false;
        }
        this.modConfiguration.getCategory(string);
        for (Property property : this.modConfiguration.getCategory(string).values()) {
            this.copyProperty(string, property.getName(), string2, property.getName(), true);
        }
        this.removeCategory(string);
        return true;
    }

    public boolean removeCategory(String string) {
        if (!this.modConfiguration.hasCategory(string)) {
            return false;
        }
        this.modConfiguration.removeCategory(this.modConfiguration.getCategory(string));
        return true;
    }

    public void cleanUp(boolean bl, boolean bl2) {
        this.removeProperty("version", "version");
        this.removeProperty("version", "Version");
        this.removeProperty("general", "version");
        this.removeProperty("general", "Version");
        this.removeProperty("Version", "Identifier");
        if (bl2) {
            this.getConfigVersion();
        }
        this.modConfiguration.save();
        if (bl) {
            this.modConfiguration = null;
        }
    }
}

