/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.CoFHCore;
import cofh.core.CoFHProps;
import cofh.core.entity.EntityLightningBoltFake;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class CoreUtils {
    public static int entityId = 0;

    public static int getEntityId() {
        return ++entityId;
    }

    public static String getModName(Item var0) {
        String var1 = GameData.getItemRegistry().func_148750_c((Object)var0);
        return var1.substring(0, var1.indexOf(58));
    }

    public static EntityPlayer getClientPlayer() {
        return CoFHCore.proxy.getClientPlayer();
    }

    public static boolean isPlayer(EntityPlayer var0) {
        return var0 instanceof EntityPlayerMP;
    }

    public static boolean isFakePlayer(EntityPlayer var0) {
        return var0 instanceof FakePlayer;
    }

    public static boolean isOp(EntityPlayer var0) {
        return CoFHCore.proxy.isOp(var0.func_70005_c_());
    }

    public static boolean isOp(String var0) {
        return CoFHCore.proxy.isOp(var0);
    }

    public static boolean isClient() {
        return CoFHCore.proxy.isClient();
    }

    public static boolean isServer() {
        return CoFHCore.proxy.isServer();
    }

    public static boolean isBlockUnbreakable(World var0, int var1, int var2, int var3) {
        Block var4 = var0.func_147439_a(var1, var2, var3);
        return var4 instanceof BlockLiquid || var4.func_149712_f(var0, var1, var2, var3) < 0.0f;
    }

    public static boolean isRedstonePowered(World var0, int var1, int var2, int var3) {
        if (var0.func_72864_z(var1, var2, var3)) {
            return true;
        }
        for (BlockPosition var5 : new BlockPosition(var1, var2, var3).getAdjacent(false)) {
            Block var6 = var0.func_147439_a(var5.x, var5.y, var5.z);
            if (!var6.equals(Blocks.field_150488_af) || var6.func_149748_c((IBlockAccess)var0, var5.x, var5.y, var5.z, 1) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isRedstonePowered(TileEntity var0) {
        return CoreUtils.isRedstonePowered(var0.func_145831_w(), var0.field_145851_c, var0.field_145848_d, var0.field_145849_e);
    }

    public static void dismantleLog(String var0, Block var1, int var2, double var3, double var5, double var7) {
        if (CoFHProps.enableDismantleLogging) {
            CoFHCore.log.info("Player " + var0 + " dismantled  (" + var1 + ":" + var2 + ") at (" + var3 + "," + var5 + "," + var7 + ")");
        }
    }

    public static void copyFileUsingStream(String var0, String var1) throws IOException {
        CoreUtils.copyFileUsingStream(var0, new File(var1));
    }

    public static void copyFileUsingStream(String var0, File var1) throws IOException {
        try (InputStream var2 = CoreUtils.class.getClassLoader().getResourceAsStream(var0);
             FileOutputStream var4 = new FileOutputStream(var1);){
            int var7;
            byte[] var6 = new byte[1024];
            while ((var7 = var2.read(var6)) > 0) {
                var4.write(var6, 0, var7);
            }
        }
    }

    public static void copyFileUsingChannel(File var0, File var1) throws IOException {
        try (FileInputStream var2 = new FileInputStream(var0);
             FileChannel var4 = var2.getChannel();
             FileOutputStream var6 = new FileOutputStream(var1);){
            var6.getChannel().transferFrom(var4, 0L, var4.size());
        }
    }

    public static final String getSoundName(String var0, String var1) {
        var1 = var1.replaceAll("/", ".");
        return String.format("%s:%s", var0, var1);
    }

    public static final float getSoundVolume(int var0) {
        return CoFHCore.proxy.getSoundVolume(var0);
    }

    public static boolean dropItemStackIntoWorld(ItemStack var0, World var1, double var2, double var4, double var6) {
        return CoreUtils.dropItemStackIntoWorld(var0, var1, var2, var4, var6, false);
    }

    public static boolean dropItemStackIntoWorldWithVelocity(ItemStack var0, World var1, double var2, double var4, double var6) {
        return CoreUtils.dropItemStackIntoWorld(var0, var1, var2, var4, var6, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack var0, World var1, double var2, double var4, double var6, boolean var8) {
        if (var0 == null) {
            return false;
        }
        float var9 = 0.5f;
        float var10 = 0.0f;
        float var11 = 0.5f;
        if (var8) {
            var9 = var1.field_73012_v.nextFloat() * 0.8f + 0.1f;
            var10 = var1.field_73012_v.nextFloat() * 0.8f + 0.1f;
            var11 = var1.field_73012_v.nextFloat() * 0.8f + 0.1f;
        }
        EntityItem var12 = new EntityItem(var1, var2 + (double)var9, var4 + (double)var10, var6 + (double)var11, var0.func_77946_l());
        if (var8) {
            var12.field_70159_w = (float)var1.field_73012_v.nextGaussian() * 0.05f;
            var12.field_70181_x = (float)var1.field_73012_v.nextGaussian() * 0.05f + 0.2f;
            var12.field_70179_y = (float)var1.field_73012_v.nextGaussian() * 0.05f;
        } else {
            var12.field_70181_x = -0.05f;
            var12.field_70159_w = 0.0;
            var12.field_70179_y = 0.0;
        }
        var1.func_72838_d((Entity)var12);
        return true;
    }

    public static void doFakeExplosion(World var0, double var1, double var3, double var5, boolean var7) {
        var0.func_72869_a("largeexplode", var1, var3 + 1.0, var5, 0.0, 0.0, 0.0);
        if (var7) {
            var0.func_72980_b(var1, var3, var5, "random.explode", 1.0f, 1.0f, true);
        }
    }

    public static void doFakeLightningBolt(World var0, double var1, double var3, double var5) {
        EntityLightningBoltFake var7 = new EntityLightningBoltFake(var0, var1, var3, var5);
        var0.func_72942_c((Entity)var7);
    }

    public static boolean teleportEntityTo(Entity var0, double var1, double var3, double var5) {
        if (var0 instanceof EntityLivingBase) {
            return CoreUtils.teleportEntityTo((EntityLivingBase)var0, var1, var3, var5);
        }
        var0.func_70012_b(var1, var3, var5, var0.field_70177_z, var0.field_70125_A);
        var0.field_70170_p.func_72956_a(var0, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(EntityLivingBase var0, double var1, double var3, double var5) {
        EnderTeleportEvent var7 = new EnderTeleportEvent(var0, var1, var3, var5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)var7)) {
            return false;
        }
        var0.func_70634_a(var7.targetX, var7.targetY, var7.targetZ);
        var0.field_70170_p.func_72956_a((Entity)var0, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(EntityLivingBase var0, double var1, double var3, double var5, boolean var7) {
        if (var7) {
            NBTTagCompound var8 = var0.getEntityData();
            long var9 = var0.field_70170_p.func_82737_E();
            if (var8.func_74763_f("cofh:tD") > var9) {
                return false;
            }
            var8.func_74772_a("cofh:tD", var9 + 35L);
        }
        return CoreUtils.teleportEntityTo(var0, var1, var3, var5);
    }
}

