/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod.updater;

import cofh.core.CoFHProps;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.ModVersion;
import cofh.mod.updater.UpdateCheckThread;
import com.gamerforea.cofh.EventConfig;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public final class UpdateManager {
    private static transient int pollOffset = 0;
    private static final ChatStyle description = new ChatStyle();
    private static final ChatStyle version = new ChatStyle();
    private static final ChatStyle modname = new ChatStyle();
    private static final ChatStyle download = new ChatStyle();
    private static final ChatStyle white = new ChatStyle();
    private boolean _notificationDisplayed;
    private final IUpdatableMod _mod;
    private UpdateCheckThread _updateThread;
    private final String _downloadUrl;
    private int lastPoll = 400;

    public static void registerUpdater(UpdateManager var0) {
        if (!EventConfig.updateCheck) {
            return;
        }
        FMLCommonHandler.instance().bus().register((Object)var0);
    }

    public UpdateManager(IUpdatableMod var1) {
        this(var1, null);
    }

    public UpdateManager(IUpdatableMod var1, String var2) {
        this(var1, var2, null);
    }

    public UpdateManager(IUpdatableMod var1, String var2, String var3) {
        this._mod = var1;
        if (EventConfig.updateCheck) {
            this._updateThread = new UpdateCheckThread(var1, var2, var3);
            this._updateThread.start();
        }
        this._downloadUrl = var3;
        this.lastPoll += (pollOffset += 140);
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent var1) {
        if (!EventConfig.updateCheck) {
            return;
        }
        if (var1.phase == TickEvent.Phase.START && (MinecraftServer.func_71276_C() == null || !MinecraftServer.func_71276_C().func_71278_l() || MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(var1.player.func_146103_bH()))) {
            if (this.lastPoll > 0) {
                --this.lastPoll;
            } else {
                this.lastPoll = 400;
                if (!this._notificationDisplayed && this._updateThread.checkComplete()) {
                    this._notificationDisplayed = true;
                    FMLCommonHandler.instance().bus().unregister((Object)this);
                    if (this._updateThread.newVersionAvailable()) {
                        if (!CoFHProps.enableUpdateNotice && !this._updateThread.isCriticalUpdate()) {
                            return;
                        }
                        ModVersion var2 = this._updateThread.newVersion();
                        EntityPlayer var3 = var1.player;
                        ChatComponentText var4 = new ChatComponentText("");
                        ChatStyle var5 = modname.func_150232_l();
                        IChatComponent var6 = new ChatComponentText(var2.modVersion().toString()).func_150255_a(version);
                        var5.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, var6));
                        var4.func_150257_a(new ChatComponentText("[" + this._mod.getModName() + "] ").func_150255_a(var5));
                        var4.func_150257_a(new ChatComponentTranslation("info.cofh.updater.version", new Object[0]).func_150255_a(white));
                        var4.func_150258_a(EnumChatFormatting.GOLD + ":");
                        var3.func_145747_a((IChatComponent)var4);
                        var4 = new ChatComponentText("");
                        if (!Strings.isNullOrEmpty((String)this._downloadUrl)) {
                            var4.func_150258_a(EnumChatFormatting.WHITE + "[");
                            var5 = download.func_150232_l();
                            var5.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this._downloadUrl));
                            var4.func_150257_a(new ChatComponentTranslation("info.cofh.updater.download", new Object[0]).func_150255_a(var5));
                            var4.func_150258_a(EnumChatFormatting.WHITE + "] ");
                        }
                        var4.func_150257_a(new ChatComponentText(var2.description()).func_150255_a(description));
                        var3.func_145747_a((IChatComponent)var4);
                    }
                }
            }
        }
    }

    static {
        description.func_150238_a(EnumChatFormatting.GRAY);
        version.func_150238_a(EnumChatFormatting.AQUA);
        modname.func_150238_a(EnumChatFormatting.GOLD);
        download.func_150238_a(EnumChatFormatting.GREEN);
        white.func_150238_a(EnumChatFormatting.WHITE);
        ChatStyle var0 = new ChatStyle();
        var0.func_150238_a(EnumChatFormatting.YELLOW);
        IChatComponent var1 = new ChatComponentTranslation("info.cofh.updater.tooltip", new Object[0]).func_150255_a(var0);
        download.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, var1));
    }
}

