/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.ICannerBottleRecipeManager;
import ic2.api.recipe.ICannerEnrichRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputFluidContainer;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import ml.luxinfine.minetweaker.mods.ic2.ModUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.Canner")
@ModOnly(value={"IC2"})
public class Canner {
    @ZenMethod
    public static void addBottleRecipe(IItemStack output, IIngredient container, IIngredient fill) {
        MineTweakerAPI.apply(new AddBottleIngredientAction(container, fill, output));
    }

    @ZenMethod
    public static void addBottleRecipe(IItemStack output, IIngredient container, ILiquidStack liquid) {
        MineTweakerAPI.apply(new AddBottleLiquidAction(container, liquid, output));
    }

    @ZenMethod
    public static void addEnrichRecipe(ILiquidStack output, ILiquidStack input, IIngredient additive) {
        MineTweakerAPI.apply(new AddEnrichIngredientAction(input, additive, output));
    }

    @ZenMethod
    public static void addEnrichRecipe(ILiquidStack output, ILiquidStack input, ILiquidStack additive) {
        MineTweakerAPI.apply(new AddEnrichLiquidAction(input, additive, output));
    }

    @ZenMethod
    public static void removeBottleRecipe(IItemStack output) {
        MineTweakerAPI.apply(new BottleRecipeRemover(MineTweakerMC.getItemStack(output)));
    }

    @ZenMethod
    public static void removeEnrichRecipe(ILiquidStack output) {
        MineTweakerAPI.apply(new EnrichRecipeRemover(output == null ? null : (FluidStack)output.getInternal()));
    }

    private static class AddEnrichLiquidAction
    implements IUndoableAction {
        private final ILiquidStack input;
        private final ILiquidStack additive;
        private final ILiquidStack output;
        private final ICannerEnrichRecipeManager.Input inputInternal;
        private FluidStack replacedRecipe;

        public AddEnrichLiquidAction(ILiquidStack input, ILiquidStack additive, ILiquidStack output) {
            this.input = input;
            this.additive = additive;
            this.output = output;
            this.inputInternal = new ICannerEnrichRecipeManager.Input((FluidStack)input.getInternal(), (IRecipeInput)new RecipeInputFluidContainer(((FluidStack)additive.getInternal()).getFluid(), additive.getAmount()));
        }

        @Override
        public void apply() {
            this.replacedRecipe = Recipes.cannerEnrich.getRecipes().put(this.inputInternal, (FluidStack)this.output.getInternal());
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Iterator it = Recipes.cannerEnrich.getRecipes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (!Objects.equals(r.getKey(), this.inputInternal)) continue;
                it.remove();
                break;
            }
            if (this.replacedRecipe != null) {
                Recipes.cannerEnrich.getRecipes().put(this.inputInternal, this.replacedRecipe);
            }
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Adding canner enrich recipe " + this.input + " + " + this.additive + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 19 * hash + (this.additive != null ? this.additive.hashCode() : 0);
            hash = 19 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddEnrichLiquidAction other = (AddEnrichLiquidAction)obj;
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (!(this.additive == other.additive || this.additive != null && this.additive.equals(other.additive))) {
                return false;
            }
            return this.output == other.output || this.output != null && this.output.equals(other.output);
        }
    }

    private static class AddEnrichIngredientAction
    implements IUndoableAction {
        private final ILiquidStack input;
        private final IIngredient additive;
        private final ILiquidStack output;
        private final ICannerEnrichRecipeManager.Input inputInternal;
        private FluidStack replacedRecipe;

        public AddEnrichIngredientAction(ILiquidStack input, IIngredient additive, ILiquidStack output) {
            this.input = input;
            this.additive = additive;
            this.output = output;
            this.inputInternal = new ICannerEnrichRecipeManager.Input((FluidStack)input.getInternal(), ModUtils.getInputWrapper(additive));
        }

        @Override
        public void apply() {
            this.replacedRecipe = Recipes.cannerEnrich.getRecipes().put(this.inputInternal, (FluidStack)this.output.getInternal());
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Iterator it = Recipes.cannerEnrich.getRecipes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (!Objects.equals(r.getKey(), this.inputInternal)) continue;
                it.remove();
                break;
            }
            if (this.replacedRecipe != null) {
                Recipes.cannerEnrich.getRecipes().put(this.inputInternal, this.replacedRecipe);
            }
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Adding canner enrich recipe " + this.input + " + " + this.additive + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 47 * hash + (this.additive != null ? this.additive.hashCode() : 0);
            hash = 47 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddEnrichIngredientAction other = (AddEnrichIngredientAction)obj;
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (!(this.additive == other.additive || this.additive != null && this.additive.equals(other.additive))) {
                return false;
            }
            return this.output == other.output || this.output != null && this.output.equals(other.output);
        }
    }

    private static class AddBottleLiquidAction
    implements IUndoableAction {
        private final IIngredient container;
        private final ILiquidStack fill;
        private final IItemStack output;
        private final ICannerBottleRecipeManager.Input input;
        private RecipeOutput replacedRecipe;

        public AddBottleLiquidAction(IIngredient container, ILiquidStack fill, IItemStack output) {
            this.container = container;
            this.fill = fill;
            this.output = output;
            this.input = new ICannerBottleRecipeManager.Input(ModUtils.getInputWrapper(container), (IRecipeInput)new RecipeInputFluidContainer(((FluidStack)fill.getInternal()).getFluid(), fill.getAmount()));
        }

        @Override
        public void apply() {
            this.replacedRecipe = Recipes.cannerBottle.getRecipes().put(this.input, new RecipeOutput(null, new ItemStack[]{MineTweakerMC.getItemStack(this.output)}));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Iterator it = Recipes.cannerBottle.getRecipes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (!Objects.equals(r.getKey(), this.input)) continue;
                it.remove();
                break;
            }
            if (this.replacedRecipe != null) {
                Recipes.cannerBottle.getRecipes().put(this.input, this.replacedRecipe);
            }
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Adding cannor bottle recipe " + this.container + " + " + this.fill + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddBottleIngredientAction
    implements IUndoableAction {
        private final IIngredient container;
        private final IIngredient fill;
        private final IItemStack output;
        private final ICannerBottleRecipeManager.Input input;
        private RecipeOutput replacedRecipe;

        public AddBottleIngredientAction(IIngredient container, IIngredient fill, IItemStack output) {
            this.container = container;
            this.fill = fill;
            this.output = output;
            this.input = new ICannerBottleRecipeManager.Input(ModUtils.getInputWrapper(container), ModUtils.getInputWrapper(fill));
        }

        @Override
        public void apply() {
            this.replacedRecipe = Recipes.cannerBottle.getRecipes().put(this.input, new RecipeOutput(null, new ItemStack[]{MineTweakerMC.getItemStack(this.output)}));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Iterator it = Recipes.cannerBottle.getRecipes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (!Objects.equals(r.getKey(), this.input)) continue;
                it.remove();
                break;
            }
            if (this.replacedRecipe != null) {
                Recipes.cannerBottle.getRecipes().put(this.input, this.replacedRecipe);
            }
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Adding canner bottle recipe " + this.container + " + " + this.fill + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.container != null ? this.container.hashCode() : 0);
            hash = 67 * hash + (this.fill != null ? this.fill.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddBottleIngredientAction other = (AddBottleIngredientAction)obj;
            if (!(this.container == other.container || this.container != null && this.container.equals(other.container))) {
                return false;
            }
            if (!(this.fill == other.fill || this.fill != null && this.fill.equals(other.fill))) {
                return false;
            }
            return this.output == other.output || this.output != null && this.output.equals(other.output);
        }
    }

    private static class EnrichRecipeRemover
    implements IUndoableAction {
        private final FluidStack out;
        private final List<Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack>> removedRecipes = new ArrayList<Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack>>();

        EnrichRecipeRemover(FluidStack out) {
            this.out = out;
        }

        @Override
        public void apply() {
            Iterator it = Recipes.cannerEnrich.getRecipes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (this.out != null && (((FluidStack)r.getValue()).getFluid() != this.out.getFluid() || ((FluidStack)r.getValue()).amount != this.out.amount)) continue;
                it.remove();
                this.removedRecipes.add(r);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Map crafts = Recipes.cannerEnrich.getRecipes();
            this.removedRecipes.forEach(entry -> {
                FluidStack cfr_ignored_0 = (FluidStack)crafts.put(entry.getKey(), entry.getValue());
            });
        }

        @Override
        public String describe() {
            return "Removing canner bottle recipes with output " + (this.out == null ? "ALL" : this.out.getLocalizedName());
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class BottleRecipeRemover
    implements IUndoableAction {
        private final ItemStack out;
        private final List<Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput>> removedRecipes = new ArrayList<Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput>>();

        BottleRecipeRemover(ItemStack out) {
            this.out = out;
        }

        @Override
        public void apply() {
            Iterator it = Recipes.cannerBottle.getRecipes().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (this.out != null && !ModUtils.equals(((RecipeOutput)r.getValue()).items, this.out)) continue;
                it.remove();
                this.removedRecipes.add(r);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Map crafts = Recipes.cannerBottle.getRecipes();
            this.removedRecipes.forEach(entry -> {
                RecipeOutput cfr_ignored_0 = (RecipeOutput)crafts.put(entry.getKey(), entry.getValue());
            });
        }

        @Override
        public String describe() {
            return "Removing canner bottle recipes with output " + (this.out == null ? "ALL" : this.out.func_82833_r());
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

