/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.Recipes;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import ml.luxinfine.minetweaker.mods.ic2.ModUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.Recycler")
@ModOnly(value={"IC2"})
public class Recycler {
    @ZenMethod
    public static void addBlacklist(IIngredient ingredient) {
        MineTweakerAPI.apply(new AddBlacklistAction(ingredient));
    }

    @ZenMethod
    public static boolean isBlacklisted(IItemStack item) {
        return Recipes.recyclerBlacklist.contains(MineTweakerMC.getItemStack(item));
    }

    private static class AddBlacklistAction
    implements IUndoableAction {
        private IIngredient ingredient;
        private final IRecipeInput recipe;

        public AddBlacklistAction(IIngredient ingredient) {
            this.ingredient = ingredient;
            this.recipe = ModUtils.getInputWrapper(ingredient);
        }

        @Override
        public void apply() {
            Recipes.recyclerBlacklist.add(this.recipe);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Recipes.recyclerBlacklist.getInputs().remove(this.recipe);
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Adding " + this.ingredient + " to the recycler blacklist";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 3;
            hash = 29 * hash + (this.ingredient != null ? this.ingredient.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddBlacklistAction other = (AddBlacklistAction)obj;
            return this.ingredient == other.ingredient || this.ingredient != null && this.ingredient.equals(other.ingredient);
        }
    }
}

