/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.ISemiFluidFuelManager;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.SemiFluidGenerator")
@ModOnly(value={"IC2"})
public class SemiFluidGenerator {
    @ZenMethod
    public static void addFluid(ILiquidStack liquidPerTick, int energyPerTick) {
        MineTweakerAPI.apply(new AddFluidAction(liquidPerTick.getName(), liquidPerTick.getAmount(), energyPerTick));
    }

    @ZenMethod
    public static boolean accepts(ILiquidStack liquid) {
        return Recipes.semiFluidGenerator.acceptsFluid(FluidRegistry.getFluid((String)liquid.getName()));
    }

    @ZenMethod
    public static void removeFluid(ILiquidStack fluid) {
        MineTweakerAPI.apply(fluid == null ? null : new SemiFluidRemover(fluid.getName()));
    }

    private static class AddFluidAction
    implements IUndoableAction {
        private final String name;
        private final int liquidPerTick;
        private final int energyPerTick;
        private ISemiFluidFuelManager.BurnProperty replacedRecipe;

        public AddFluidAction(String name, int liquidPerTick, int energyPerTick) {
            this.name = name;
            this.liquidPerTick = liquidPerTick;
            this.energyPerTick = energyPerTick;
        }

        @Override
        public void apply() {
            this.replacedRecipe = Recipes.semiFluidGenerator.getBurnProperties().put(this.name, new ISemiFluidFuelManager.BurnProperty(this.liquidPerTick, (double)this.energyPerTick));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Iterator it = Recipes.semiFluidGenerator.getBurnProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (!((String)r.getKey()).equals(this.name)) continue;
                it.remove();
                break;
            }
            if (this.replacedRecipe != null) {
                Recipes.semiFluidGenerator.getBurnProperties().put(this.name, this.replacedRecipe);
            }
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public String describe() {
            return "Adding liquid " + this.name + " as semifluid fuel";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 47 * hash + this.liquidPerTick;
            hash = 47 * hash + this.energyPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddFluidAction other = (AddFluidAction)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.liquidPerTick != other.liquidPerTick) {
                return false;
            }
            return this.energyPerTick == other.energyPerTick;
        }
    }

    private static class SemiFluidRemover
    implements IUndoableAction {
        private final String name;
        private final List<Map.Entry<String, ISemiFluidFuelManager.BurnProperty>> removedRecipes = new ArrayList<Map.Entry<String, ISemiFluidFuelManager.BurnProperty>>();

        public SemiFluidRemover(String fluidName) {
            this.name = fluidName;
        }

        @Override
        public void apply() {
            Iterator it = Recipes.semiFluidGenerator.getBurnProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry r = it.next();
                if (this.name != null && !((String)r.getKey()).equals(this.name)) continue;
                it.remove();
                this.removedRecipes.add(r);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            Map recipes = Recipes.semiFluidGenerator.getBurnProperties();
            this.removedRecipes.forEach(entry -> {
                ISemiFluidFuelManager.BurnProperty cfr_ignored_0 = (ISemiFluidFuelManager.BurnProperty)recipes.put(entry.getKey(), entry.getValue());
            });
        }

        @Override
        public String describe() {
            return "Removing SemiFluidGenerator fluid " + (this.name == null ? "ALL" : this.name);
        }

        @Override
        public String describeUndo() {
            return "Un" + this.describe();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

