/*
 * Decompiled with CFR 0.152.
 */
package ml.luxinfine.minetweaker.mods.ic2;

import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import java.util.List;
import javax.annotation.Nonnull;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientStack;
import minetweaker.mc1710.item.MCItemStack;
import minetweaker.mc1710.oredict.MCOreDictEntry;
import minetweaker.mods.ic2.IC2RecipeInput;
import ml.luxinfine.minetweaker.mods.ic2.IC2NBTItemRecipe;
import net.minecraft.item.ItemStack;

public class ModUtils {
    public static IRecipeInput getInputWrapper(IIngredient ingredient) {
        Class<?> type = ingredient.getClass();
        if (type == MCOreDictEntry.class) {
            return new RecipeInputOreDict(((MCOreDictEntry)ingredient).getName());
        }
        if (type == MCItemStack.class) {
            ItemStack stack = (ItemStack)ingredient.getInternal();
            return stack.func_77942_o() ? new IC2NBTItemRecipe(stack) : new RecipeInputItemStack(stack, stack.field_77994_a);
        }
        if (type == IngredientStack.class) {
            IItemStack inner;
            try {
                IIngredient inner2 = (IIngredient)ReflectionHelper.getPrivateValue(IngredientStack.class, (Object)((IngredientStack)ingredient), (String[])new String[]{"ingredient"});
                if (inner2.getClass() == MCOreDictEntry.class) {
                    return new RecipeInputOreDict(((MCOreDictEntry)inner2).getName(), ingredient.getAmount());
                }
            }
            catch (Throwable inner2) {
                // empty catch block
            }
            List<IItemStack> list = ingredient.getItems();
            if (!list.isEmpty() && (inner = list.get(0)) != null && inner.getClass() == MCItemStack.class) {
                ItemStack stack = (ItemStack)inner.getInternal();
                return stack.func_77942_o() ? new IC2NBTItemRecipe(stack) : new RecipeInputItemStack(stack, stack.field_77994_a);
            }
        }
        return new IC2RecipeInput(ingredient);
    }

    public static boolean equals(@Nonnull List<ItemStack> itemsList, ItemStack ... itemsArray) {
        if (itemsArray.length != itemsList.size()) {
            return false;
        }
        for (int i = 0; i < itemsArray.length; ++i) {
            ItemStack s1 = itemsArray[i];
            ItemStack s2 = itemsList.get(i);
            if (s1 == s2) continue;
            if (s1 == null || s2 == null) {
                return false;
            }
            if (s1.func_77973_b() != s2.func_77973_b()) {
                return false;
            }
            if (s1.func_77960_j() != s2.func_77960_j()) {
                return false;
            }
            if (ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2)) continue;
            return false;
        }
        return true;
    }
}

