/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.common.items.weapons.BowHandler;
import com.gamerforea.draconicevolution.ModelWrapperDisplayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class RenderBowModel
implements IItemRenderer {
    private boolean draconic;
    private IModelCustom[] wyvernModels = new IModelCustom[4];
    private IModelCustom[] draconicModels = new IModelCustom[4];
    private IModelCustom arrow;

    public RenderBowModel(boolean draconic) {
        int i;
        this.draconic = draconic;
        for (i = 0; i < 4; ++i) {
            this.wyvernModels[i] = new ModelWrapperDisplayList((WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)ResourceHandler.getResource("models/tools/WyvernBow0" + i + ".obj")));
        }
        for (i = 0; i < 4; ++i) {
            this.draconicModels[i] = new ModelWrapperDisplayList((WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)ResourceHandler.getResource("models/tools/DraconicBow0" + i + ".obj")));
        }
        this.arrow = new ModelWrapperDisplayList((WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)ResourceHandler.getResource("models/tools/ArrowCommon.obj")));
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        IModelCustom activeModel;
        EntityPlayer player;
        GL11.glPushMatrix();
        float j = 0.0f;
        int selection = 0;
        BowHandler.BowProperties properties = null;
        if (data.length >= 2 && data[1] instanceof EntityPlayer && (j = (float)(player = (EntityPlayer)data[1]).func_71057_bx()) > 0.0f) {
            int j2;
            properties = new BowHandler.BowProperties(item, player);
            if (j > (float)properties.getDrawTicks()) {
                j = properties.getDrawTicks();
            }
            if ((j2 = (int)((j /= (float)properties.getDrawTicks()) * 3.0f)) < 0) {
                j2 = 0;
            } else if (j2 > 3) {
                j2 = 3;
            }
            selection = j2;
        }
        if (this.draconic) {
            activeModel = this.draconicModels[selection];
            ResourceHandler.bindResource("textures/models/tools/DraconicBow0" + selection + ".png");
        } else {
            activeModel = this.draconicModels[selection];
            ResourceHandler.bindResource("textures/models/tools/WyvernBow0" + selection + ".png");
        }
        if (activeModel != null) {
            this.doRender(activeModel, type, j > 0.0f ? selection : -1, properties);
        }
        GL11.glPopMatrix();
    }

    private void doRender(IModelCustom modelCustom, IItemRenderer.ItemRenderType type, int drawState, BowHandler.BowProperties properties) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            GL11.glTranslated((double)0.7, (double)0.0, (double)0.2);
            GL11.glRotatef((float)87.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)190.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            GL11.glTranslated((double)0.7, (double)0.7, (double)0.2);
            GL11.glRotatef((float)130.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)6.0f, (float)6.0f, (float)6.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)0.0, (double)1.5);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            GL11.glTranslated((double)0.25, (double)0.7, (double)0.2);
            GL11.glRotatef((float)130.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        modelCustom.renderAll();
        if (drawState != -1) {
            GL11.glTranslated((double)0.3, (double)0.151, (double)(-0.2 + (drawState == 1 ? 0.0 : (drawState == 2 ? 0.55 : (drawState == 3 ? 1.0 : -0.7)))));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (properties != null && properties.energyBolt) {
                ResourceHandler.bindResource("textures/models/reactorCore.png");
                this.arrow.renderAll();
                GL11.glTranslated((double)0.0, (double)-0.025, (double)0.0);
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
                GL11.glScaled((double)1.05, (double)1.05, (double)1.05);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                GL11.glScaled((double)1.05, (double)1.05, (double)1.05);
                this.arrow.renderAll();
            } else {
                ResourceHandler.bindResource("textures/models/tools/ArrowCommon.png");
                this.arrow.renderAll();
            }
        }
    }
}

