/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.draconicevolution;

import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ModelWrapperDisplayList
implements IModelCustom {
    private final Map<String, Integer> lists = new HashMap<String, Integer>();
    private final IntBuffer bufAll;
    private final String type;

    public ModelWrapperDisplayList(WavefrontObject model) {
        this.type = model.getType();
        int list = GL11.glGenLists((int)model.groupObjects.size());
        for (GroupObject obj : model.groupObjects) {
            GL11.glNewList((int)list, (int)4864);
            model.renderPart(obj.name);
            GL11.glEndList();
            this.lists.put(obj.name, list++);
        }
        this.bufAll = this.initBuffer();
    }

    private IntBuffer initBuffer() {
        IntBuffer buf = BufferUtils.createIntBuffer((int)this.lists.size());
        for (int i : this.lists.values()) {
            buf.put(i);
        }
        buf.flip();
        return buf;
    }

    public String getType() {
        return this.type;
    }

    public void renderAll() {
        GL11.glCallLists((IntBuffer)this.bufAll);
    }

    public void renderOnly(String ... groupNames) {
        if (groupNames == null || groupNames.length == 0) {
            return;
        }
        for (String group : groupNames) {
            this.renderPart(group);
        }
    }

    public void renderPart(String partName) {
        Integer list = this.lists.get(partName);
        if (list != null) {
            GL11.glCallList((int)list);
        }
    }

    public void renderAllExcept(String ... groupNames) {
        if (groupNames == null || groupNames.length == 0) {
            this.renderAll();
            return;
        }
        for (Map.Entry<String, Integer> it : this.lists.entrySet()) {
            if (Arrays.binarySearch(groupNames, it.getKey(), String::compareTo) >= 0) continue;
            GL11.glCallList((int)it.getValue());
        }
    }
}

