/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Core.CoreInitialiser;
import DummyCore.Utils.BlockPosition;
import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.DummyPacketHandler;
import DummyCore.Utils.DummyPacketIMSG;
import DummyCore.Utils.DummyPacketIMSG_Tile;
import DummyCore.Utils.ITEHasGameData;
import DummyCore.Utils.Notifier;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class MiscUtils {
    public static final String genUUIDString = "CB3F55A9-6DCC-4FF8-AAC7-9B87A33";
    public static Hashtable<String, String> descriptionTable = new Hashtable();
    public static Hashtable<String, EnumChatFormatting> descriptionCTable = new Hashtable();
    public static Hashtable<List<?>, String> descriptionNTable = new Hashtable();
    public static Hashtable<List<?>, EnumChatFormatting> descriptionNCTable = new Hashtable();
    public static Hashtable<String, String> registeredClientData = new Hashtable();
    public static Hashtable<String, String> registeredClientWorldData = new Hashtable();
    public static Hashtable<String, String> registeredServerData = new Hashtable();
    public static Hashtable<String, String> registeredServerWorldData = new Hashtable();
    public static List<BlockPosition> unbreakableBlocks = new ArrayList<BlockPosition>();
    public static Hashtable<String, ResourceLocation> locTable = new Hashtable();
    public static final ResourceLocation[] defaultShaders = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json")};

    @SideOnly(value=Side.CLIENT)
    public static void bindTexture(String mod, String texture) {
        if (locTable.contains(mod + ":" + texture)) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(locTable.get(mod + ":" + texture));
        } else {
            ResourceLocation loc = new ResourceLocation(mod, texture);
            locTable.put(mod + ":" + texture, loc);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(loc);
        }
    }

    public static void createNBTTag(ItemStack stack) {
        if (stack.func_77942_o()) {
            return;
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        stack.func_77982_d(itemTag);
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        MiscUtils.createNBTTag(stack);
        return stack.func_77978_p();
    }

    public static void dropItemsOnBlockBreak(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        try {
            IInventory inv = (IInventory)par1World.func_147438_o(par2, par3, par4);
            if (inv != null) {
                for (int j1 = 0; j1 < inv.func_70302_i_(); ++j1) {
                    ItemStack itemstack = inv.func_70301_a(j1);
                    if (itemstack == null) continue;
                    float f = par1World.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float f1 = par1World.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float f2 = par1World.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.field_77994_a > 0) {
                        int k1 = par1World.field_73012_v.nextInt(21) + 10;
                        if (k1 > itemstack.field_77994_a) {
                            k1 = itemstack.field_77994_a;
                        }
                        itemstack.field_77994_a -= k1;
                        EntityItem entityitem = new EntityItem(par1World, (double)((float)par2 + f), (double)((float)par3 + f1), (double)((float)par4 + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
                        if (itemstack.func_77942_o()) {
                            entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                        }
                        float f3 = 0.05f;
                        entityitem.field_70159_w = (float)par1World.field_73012_v.nextGaussian() * f3;
                        entityitem.field_70181_x = (float)par1World.field_73012_v.nextGaussian() * f3 + 0.2f;
                        entityitem.field_70179_y = (float)par1World.field_73012_v.nextGaussian() * f3;
                        par1World.func_72838_d((Entity)entityitem);
                    }
                }
            }
        }
        catch (Exception ex) {
            Notifier.notifyCustomMod("DummyCore", "[ERROR]Trying to drop items upon block breaking, but caught an exception:");
            ex.printStackTrace();
            return;
        }
    }

    public static boolean oreDictionaryContains(String oreName) {
        return !OreDictionary.getOres((String)oreName).isEmpty();
    }

    public static void syncTileEntity(ITEHasGameData t, Side s) {
        String dataString = "||mod:DummyCore.TileSync" + t.getPosition() + t.getData();
        DummyPacketIMSG simplePacket = new DummyPacketIMSG(dataString);
        if (s == Side.CLIENT) {
            DummyPacketHandler.sendToAll(simplePacket);
        }
        if (s == Side.SERVER) {
            DummyPacketHandler.sendToServer(simplePacket);
        }
    }

    public static void syncTileEntity(NBTTagCompound tileTag, int packetID) {
        DummyPacketIMSG_Tile simplePacket = new DummyPacketIMSG_Tile(tileTag);
        CoreInitialiser.network.sendToAll((IMessage)simplePacket);
    }

    @Deprecated
    public static void makeItemIgnoreDamage(Item i) {
    }

    @Deprecated
    public static void registerItemModifier(Item id, int meta, String type, String last5ofUUID, double value, IAttribute attrib, int operation) {
    }

    public static void applyPlayerModifier(EntityPlayer p, IAttribute attrib, String uuidLast5Symbols, double modifier, boolean remove, int operation, String type) {
        if (p.func_110140_aT().func_111151_a(attrib).func_111127_a(UUID.fromString(genUUIDString + uuidLast5Symbols)) == null) {
            if (!remove) {
                p.func_110140_aT().func_111151_a(attrib).func_111121_a(new AttributeModifier(UUID.fromString(genUUIDString + uuidLast5Symbols), "dam." + type + "." + attrib.func_111108_a(), modifier, operation));
            }
        } else if (remove && p.func_110140_aT().func_111151_a(attrib).func_111127_a(UUID.fromString(genUUIDString + uuidLast5Symbols)) != null) {
            p.func_110140_aT().func_111151_a(attrib).func_111124_b(p.func_110140_aT().func_111151_a(attrib).func_111127_a(UUID.fromString(genUUIDString + uuidLast5Symbols)));
        }
    }

    public static void registerDescriptionFor(String unlocalisedName, String descr, EnumChatFormatting color) {
        descriptionTable.put(unlocalisedName, descr);
        descriptionCTable.put(unlocalisedName, color);
    }

    public static void registerDescriptionFor(String id, int meta, String descr, EnumChatFormatting color) {
        descriptionNTable.put(Arrays.asList(id, meta), descr);
        descriptionNCTable.put(Arrays.asList(id, meta), color);
    }

    public static void sendPacketToAllAround(World w, Packet pkt, int x, int y, int z, int dimId, double distance) {
        List playerLst = w.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)x - 0.5), (double)((double)y - 0.5), (double)((double)z - 0.5), (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5)).func_72314_b(distance, distance, distance));
        if (!playerLst.isEmpty()) {
            for (int i = 0; i < playerLst.size(); ++i) {
                EntityPlayer player = (EntityPlayer)playerLst.get(i);
                if (player instanceof EntityPlayerMP) {
                    if (pkt instanceof S35PacketUpdateTileEntity) {
                        NBTTagCompound tileTag = new NBTTagCompound();
                        w.func_147438_o(x, y, z).func_145841_b(tileTag);
                        CoreInitialiser.network.sendTo((IMessage)new DummyPacketIMSG_Tile(tileTag, -10), (EntityPlayerMP)player);
                        continue;
                    }
                    if (player.field_71093_bK != dimId) continue;
                    ((EntityPlayerMP)player).func_71121_q().func_73046_m().func_71203_ab().func_148540_a(pkt);
                    continue;
                }
                Notifier.notifyDebug("Trying to send packet " + pkt + " to all around on Client side, probably a bug, ending the packet send try");
            }
        }
    }

    public static void sendPacketToAll(World w, Packet pkt) {
        List playerLst = w.field_73010_i;
        if (!playerLst.isEmpty()) {
            for (int i = 0; i < playerLst.size(); ++i) {
                EntityPlayer player = (EntityPlayer)playerLst.get(i);
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a(pkt);
                    continue;
                }
                Notifier.notifyDebug("Trying to send packet " + pkt + " to all on Client side, probably a bug, ending the packet send try");
            }
        }
    }

    public static void sendPacketToAllInDim(World w, Packet pkt, int dimId) {
        List playerLst = w.field_73010_i;
        if (!playerLst.isEmpty()) {
            for (int i = 0; i < playerLst.size(); ++i) {
                EntityPlayer player = (EntityPlayer)playerLst.get(i);
                if (player instanceof EntityPlayerMP) {
                    if (player.field_71093_bK != dimId) continue;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a(pkt);
                    continue;
                }
                Notifier.notifyDebug("Trying to send packet " + pkt + " to all in dimension " + dimId + " on Client side, probably a bug, ending the packet send try");
            }
        }
    }

    public static void sendPacketToPlayer(World w, Packet pkt, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(pkt);
        } else {
            Notifier.notifyDebug("Trying to send packet " + pkt + " to player " + player + "||" + player.getDisplayName() + " on Client side, probably a bug, ending the packet send try");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean drawScaledTexturedRect_Items(int x, int y, IIcon icon, int width, int height, float zLevel) {
        if (icon == null) {
            return false;
        }
        MiscUtils.bindTexture("minecraft", "textures/atlas/items.png");
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)zLevel, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)zLevel, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, minU, minV);
        tessellator.func_78381_a();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean drawScaledTexturedRect(int x, int y, IIcon icon, int width, int height, float zLevel) {
        if (icon == null) {
            return false;
        }
        MiscUtils.bindTexture("minecraft", "textures/atlas/blocks.png");
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)zLevel, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)zLevel, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)zLevel, minU, minV);
        tessellator.func_78381_a();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexture(int x, int y, IIcon icon, int width, int height, float zLevel) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                MiscUtils.drawScaledTexturedRect(x + i, y + j, icon, Math.min(width - i, 16), Math.min(height - j, 16), zLevel);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexture_Items(int x, int y, IIcon icon, int width, int height, float zLevel) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                MiscUtils.drawScaledTexturedRect_Items(x + i, y + j, icon, Math.min(width - i, 16), Math.min(height - j, 16), zLevel);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean classHasMethod(Class<?> c, String mName, Class<?> ... classes) {
        try {
            Method m = c.getMethod(mName, classes);
            return m != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void saveInventory(TileEntity t, NBTTagCompound saveTag) {
        if (t instanceof IInventory) {
            IInventory tile = (IInventory)t;
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                if (tile.func_70301_a(i) == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                tile.func_70301_a(i).func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            saveTag.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    public static void loadInventory(TileEntity t, NBTTagCompound loadTag) {
        if (t instanceof IInventory) {
            IInventory tile = (IInventory)t;
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                tile.func_70299_a(i, null);
            }
            NBTTagList nbttaglist = loadTag.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte b0 = nbttagcompound1.func_74771_c("Slot");
                if (b0 < 0 || b0 >= tile.func_70302_i_()) continue;
                tile.func_70299_a((int)b0, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
            }
        }
    }

    public static void changeBiome(World w, BiomeGenBase biome, int x, int z) {
        Chunk chunk = w.func_72938_d(x, z);
        byte[] b = chunk.func_76605_m();
        byte cbiome = b[(z & 0xF) << 4 | x & 0xF];
        b[(z & 0xF) << 4 | x & 0xF] = cbiome = (byte)(biome.field_76756_M & 0xFF);
        chunk.func_76616_a(b);
        MiscUtils.notifyBiomeChange(x, z, biome.field_76756_M);
    }

    public static void spawnParticlesOnServer(String particleName, float posX, float posY, float posZ, double par5, double par6, double par7) {
        String dataString = "||mod:DummyCore.Particle";
        DummyData name = new DummyData("particleName", particleName);
        DummyData xpos = new DummyData("positionX", Float.valueOf(posX));
        DummyData ypos = new DummyData("positionX", Float.valueOf(posY));
        DummyData zpos = new DummyData("positionX", Float.valueOf(posZ));
        DummyData xmot = new DummyData("par1", par5);
        DummyData ymot = new DummyData("par2", par6);
        DummyData zmot = new DummyData("par3", par7);
        DataStorage.addDataToString(name);
        DataStorage.addDataToString(xpos);
        DataStorage.addDataToString(ypos);
        DataStorage.addDataToString(zpos);
        DataStorage.addDataToString(xmot);
        DataStorage.addDataToString(ymot);
        DataStorage.addDataToString(zmot);
        String newDataString = DataStorage.getDataString();
        dataString = dataString + newDataString;
        DummyPacketIMSG simplePacket = new DummyPacketIMSG(dataString);
        DummyPacketHandler.sendToAll(simplePacket);
    }

    public static void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, int p_73729_5_, int p_73729_6_, int zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), (double)zLevel, (double)((float)(p_73729_3_ + 0) * f), (double)((float)(p_73729_4_ + 0) * f1));
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemStack_Full(ItemStack stk, double posX, double posY, double posZ, double screenPosX, double screenPosY, double screenPosZ, float rotation, float rotationZ, float colorRed, float colorGreen, float colorBlue, float offsetX, float offsetY, float offsetZ) {
        if (stk != null) {
            ItemStack itemstack = stk.func_77946_l();
            itemstack.field_77994_a = 1;
            new ResourceLocation("textures/misc/enchanted_item_glint.png");
            RenderBlocks renderBlocksRi = new RenderBlocks();
            Random random = new Random();
            boolean renderWithColor = true;
            if (itemstack != null && itemstack.func_77973_b() != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(stk.func_94608_d()));
                TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
                random.setSeed(187L);
                GL11.glPushMatrix();
                float f2 = rotationZ;
                float f3 = rotation;
                int b0 = 1;
                if (stk.field_77994_a > 1) {
                    b0 = 2;
                }
                if (stk.field_77994_a > 5) {
                    b0 = 3;
                }
                if (stk.field_77994_a > 20) {
                    b0 = 4;
                }
                if (stk.field_77994_a > 40) {
                    b0 = 5;
                }
                GL11.glTranslated((double)((float)screenPosX + offsetX), (double)((float)screenPosY + offsetY), (double)((float)screenPosZ + offsetZ));
                GL11.glEnable((int)32826);
                EntityItem fakeItem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, stk);
                GL11.glRotatef((float)f2, (float)0.0f, (float)0.0f, (float)1.0f);
                if (!ForgeHooksClient.renderEntityItem((EntityItem)fakeItem, (ItemStack)itemstack, (float)f2, (float)f3, (Random)random, (TextureManager)Minecraft.func_71410_x().field_71446_o, (RenderBlocks)renderBlocksRi, (int)b0)) {
                    if (itemstack.func_94608_d() == 0 && itemstack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemstack.func_77973_b()).func_149645_b())) {
                        Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
                        GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
                        float f9 = 0.25f;
                        int k = block.func_149645_b();
                        if (k == 1 || k == 19 || k == 12 || k == 2) {
                            f9 = 0.5f;
                        }
                        if (block.func_149701_w() > 0) {
                            GL11.glAlphaFunc((int)516, (float)0.1f);
                            GL11.glEnable((int)3042);
                            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                        }
                        GL11.glScalef((float)f9, (float)f9, (float)f9);
                        for (int l = 0; l < b0; ++l) {
                            GL11.glPushMatrix();
                            if (l > 0) {
                                float f6 = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / f9;
                                float f7 = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / f9;
                                float f8 = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / f9;
                                GL11.glTranslatef((float)f6, (float)f7, (float)f8);
                            }
                            renderBlocksRi.func_147800_a(block, itemstack.func_77960_j(), 1.0f);
                            GL11.glPopMatrix();
                        }
                        if (block.func_149701_w() > 0) {
                            GL11.glDisable((int)3042);
                        }
                    } else if (itemstack.func_77973_b().func_77623_v()) {
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        for (int j = 0; j < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++j) {
                            random.setSeed(187L);
                            itemstack.func_77973_b().getIcon(itemstack, j);
                            MiscUtils.renderItemStack(stk, posX, posY, posZ, screenPosX, screenPosY, screenPosZ, rotation, colorRed, colorGreen, colorBlue, j, stk.field_77994_a);
                        }
                    } else {
                        if (itemstack != null && itemstack.func_77973_b() instanceof ItemCloth) {
                            GL11.glAlphaFunc((int)516, (float)0.1f);
                            GL11.glEnable((int)3042);
                            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                        }
                        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                        itemstack.func_77954_c();
                        if (renderWithColor) {
                            MiscUtils.renderItemStack(stk, posX, posY, posZ, screenPosX, screenPosY, screenPosZ, rotation, colorRed, colorGreen, colorBlue, 0, stk.field_77994_a);
                        }
                        if (itemstack != null && itemstack.func_77973_b() instanceof ItemCloth) {
                            GL11.glDisable((int)3042);
                        }
                    }
                }
                fakeItem = null;
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(stk.func_94608_d()));
                TextureUtil.func_147945_b();
            }
            itemstack = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemStack(ItemStack stk, double posX, double posY, double posZ, double screenPosX, double screenPosY, double screenPosZ, float rotation, float colorRed, float colorGreen, float colorBlue, int renderPass, int itemsAmount) {
        ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
        new RenderBlocks();
        Random random = new Random();
        IIcon p_77020_2_ = stk.func_77973_b().getIcon(stk, renderPass);
        Tessellator tessellator = Tessellator.field_78398_a;
        if (p_77020_2_ == null) {
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            ResourceLocation resourcelocation = texturemanager.func_130087_a(stk.func_77973_b().func_94901_k());
            p_77020_2_ = ((TextureMap)texturemanager.func_110581_b(resourcelocation)).func_110572_b("missingno");
        }
        float f14 = p_77020_2_.func_94209_e();
        float f15 = p_77020_2_.func_94212_f();
        float f4 = p_77020_2_.func_94206_g();
        float f5 = p_77020_2_.func_94210_h();
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.25f;
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            float f9 = 0.0625f;
            float f10 = 0.021875f;
            ItemStack itemstack = stk;
            int j = itemstack.field_77994_a;
            int b0 = j < 2 ? 1 : (j < 16 ? 2 : (j < 32 ? 3 : 4));
            GL11.glTranslatef((float)(-f7), (float)(-f8), (float)(-((f9 + f10) * (float)b0 / 2.0f)));
            for (int k = 0; k < b0; ++k) {
                if (k > 0) {
                    float x = (random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                    float y = (random.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                    random.nextFloat();
                    GL11.glTranslatef((float)x, (float)y, (float)(f9 + f10));
                } else {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(f9 + f10));
                }
                if (itemstack.func_94608_d() == 0) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                } else {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
                }
                GL11.glColor4f((float)colorRed, (float)colorGreen, (float)colorBlue, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f15, (float)f4, (float)f14, (float)f5, (int)p_77020_2_.func_94211_a(), (int)p_77020_2_.func_94216_b(), (float)f9);
                if (!itemstack.hasEffect(renderPass)) continue;
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f11 = 0.76f;
                GL11.glColor4f((float)(0.5f * f11), (float)(0.25f * f11), (float)(0.8f * f11), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f12 = 0.125f;
                GL11.glScalef((float)f12, (float)f12, (float)f12);
                float f13 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f13, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f9);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f12, (float)f12, (float)f12);
                f13 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f13), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f9);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glPopMatrix();
        } else {
            for (int l = 0; l < itemsAmount; ++l) {
                GL11.glPushMatrix();
                if (l > 0) {
                    float f10 = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f16 = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f17 = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)f10, (float)f16, (float)f17);
                }
                GL11.glColor4f((float)colorRed, (float)colorGreen, (float)colorBlue, (float)1.0f);
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a((double)(0.0f - f7), (double)(0.0f - f8), 0.0, (double)f14, (double)f5);
                tessellator.func_78374_a((double)(f6 - f7), (double)(0.0f - f8), 0.0, (double)f15, (double)f5);
                tessellator.func_78374_a((double)(f6 - f7), (double)(1.0f - f8), 0.0, (double)f15, (double)f4);
                tessellator.func_78374_a((double)(0.0f - f7), (double)(1.0f - f8), 0.0, (double)f14, (double)f4);
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
        }
    }

    public static Entity cloneEntity(Entity e) {
        Entity retEntity = null;
        try {
            retEntity = (Entity)e.getClass().getConstructor(World.class).newInstance(e.field_70170_p);
            retEntity.func_82141_a(e, true);
        }
        catch (Exception exc) {
            return retEntity;
        }
        return retEntity;
    }

    public static void notifyBiomeChange(int x, int z, int biomeID) {
        String dataString = "||mod:DummyCore.BiomeChange";
        DummyData xpos = new DummyData("positionX", x);
        DummyData zpos = new DummyData("positionZ", z);
        DummyData id = new DummyData("biomeID", biomeID);
        DataStorage.addDataToString(xpos);
        DataStorage.addDataToString(zpos);
        DataStorage.addDataToString(id);
        String newDataString = DataStorage.getDataString();
        dataString = dataString + newDataString;
        DummyPacketIMSG simplePacket = new DummyPacketIMSG(dataString);
        DummyPacketHandler.sendToAll(simplePacket);
    }

    public static float multiplyDamageByArmorAbsorbption(EntityLivingBase base, DamageSource dam, float amount) {
        if (!dam.func_76363_c()) {
            int i = 25 - base.func_70658_aO();
            float f1 = amount * (float)i;
            amount = f1 / 25.0f;
        }
        return amount;
    }

    public static float applyPotionDamageCalculations(EntityLivingBase base, DamageSource dam, float amount) {
        float f1;
        int j;
        int i;
        if (dam.func_151517_h()) {
            return amount;
        }
        if (base.func_70644_a(Potion.field_76429_m) && dam != DamageSource.field_76380_i) {
            i = (base.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            j = 25 - i;
            f1 = amount * (float)j;
            amount = f1 / 25.0f;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        i = EnchantmentHelper.func_77508_a((ItemStack[])base.func_70035_c(), (DamageSource)dam);
        if (i > 20) {
            i = 20;
        }
        if (i > 0 && i <= 20) {
            j = 25 - i;
            f1 = amount * (float)j;
            amount = f1 / 25.0f;
        }
        return amount;
    }

    public static void damageEntityIgnoreEvent(EntityLivingBase base, DamageSource dam, float amount) {
        if (!base.func_85032_ar()) {
            if (amount <= 0.0f) {
                return;
            }
            amount = MiscUtils.multiplyDamageByArmorAbsorbption(base, dam, amount);
            float f1 = amount = MiscUtils.applyPotionDamageCalculations(base, dam, amount);
            amount = Math.max(amount - base.func_110139_bj(), 0.0f);
            base.func_110149_m(base.func_110139_bj() - (f1 - amount));
            if (amount != 0.0f) {
                float f2 = base.func_110143_aJ();
                base.func_70606_j(f2 - amount);
                base.func_110142_aN().func_94547_a(dam, f2, amount);
                base.func_110149_m(base.func_110139_bj() - amount);
            }
        }
    }

    public static void setPrivateFinalValue(Class<Potion> classToAccess, Object instance, Object value, String[] fieldNames) {
        Field field = ReflectionHelper.findField(classToAccess, (String[])ObfuscationReflectionHelper.remapFieldNames((String)classToAccess.getName(), (String[])fieldNames));
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(instance, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int extendPotionArray(int byAmount) {
        int potionsOffset = Potion.field_76425_a.length;
        int pStart = 0;
        if (potionsOffset < Potion.field_76425_a.length - byAmount) {
            Potion[] potionTypes = new Potion[potionsOffset + byAmount];
            System.arraycopy(Potion.field_76425_a, 0, potionTypes, 0, potionsOffset);
            MiscUtils.setPrivateFinalValue(Potion.class, null, potionTypes, new String[]{"potionTypes", "field_76425_a", "a"});
            pStart = potionsOffset++ - 1;
        } else {
            for (int i = 0; i < Potion.field_76425_a.length; ++i) {
                if (Potion.field_76425_a[i] != null) continue;
                return i;
            }
            pStart = -1;
            Notifier.notifyCustomMod("DummyCore", "Potion Array limit reached!");
        }
        return pStart;
    }

    public static void setBlockUnbreakable(World w, int x, int y, int z, boolean remove) {
        if (!MiscUtils.isBlockUnbreakable(w, x, y, z) && !remove) {
            BlockPosition pos = new BlockPosition(w, x, y, z);
            unbreakableBlocks.add(pos);
        } else {
            for (int i = 0; i < unbreakableBlocks.size(); ++i) {
                BlockPosition pos = unbreakableBlocks.get(i);
                if (pos.x != x || pos.y != y || pos.z != z || pos.wrld.field_73011_w.field_76574_g != w.field_73011_w.field_76574_g) continue;
                unbreakableBlocks.remove(pos);
                break;
            }
        }
    }

    public static boolean isBlockUnbreakable(World w, int x, int y, int z) {
        for (int i = 0; i < unbreakableBlocks.size(); ++i) {
            BlockPosition pos = unbreakableBlocks.get(i);
            if (pos.x != x || pos.y != y || pos.z != z || pos.wrld.field_73011_w.field_76574_g != w.field_73011_w.field_76574_g) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleButtonPress(int buttonID, Class<? extends Gui> parentClass, Class<? extends GuiButton> buttonClass, EntityPlayer presser, int bX, int bY, int bZ) {
        MiscUtils.handleButtonPress(buttonID, parentClass, buttonClass, presser, bX, bY, bZ, "||data:no data");
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleButtonPress(int buttonID, Class<? extends Gui> parentClass, Class<? extends GuiButton> buttonClass, EntityPlayer presser, int bX, int bY, int bZ, String additionalData) {
        String dataString = "||mod:DummyCore.guiButton";
        DummyData id = new DummyData("id", buttonID);
        DummyData parent = new DummyData("parent", parentClass.getName());
        DummyData button = new DummyData("button", buttonClass.getName());
        DummyData player = new DummyData("player", presser.func_70005_c_());
        DummyData dx = new DummyData("x", bX);
        DummyData dy = new DummyData("y", bY);
        DummyData dz = new DummyData("z", bZ);
        DataStorage.addDataToString(id);
        DataStorage.addDataToString(parent);
        DataStorage.addDataToString(button);
        DataStorage.addDataToString(player);
        DataStorage.addDataToString(dx);
        DataStorage.addDataToString(dy);
        DataStorage.addDataToString(dz);
        String newDataString = DataStorage.getDataString();
        dataString = dataString + newDataString + additionalData;
        DummyPacketIMSG simplePacket = new DummyPacketIMSG(dataString);
        DummyPacketHandler.sendToServer(simplePacket);
    }

    public static int search_firstBlock(World w, Block toSearch, int x, int z, int maxY, int minY, int metadata, boolean shouldHaveAirAbove) {
        for (int y = maxY; y > minY; --y) {
            Block b = w.func_147439_a(x, y, z);
            int meta = w.func_72805_g(x, y, z);
            if (b == null || b == Blocks.field_150350_a) continue;
            if (b == toSearch && (metadata == -1 || metadata == Short.MAX_VALUE || metadata == meta)) {
                return y;
            }
            if (!shouldHaveAirAbove) continue;
            return -1;
        }
        return -1;
    }

    public static void openGui(World w, int x, int y, int z, EntityPlayer player, int guiID) {
        player.openGui((Object)CoreInitialiser.instance, guiID, w, x, y, z);
    }

    public static void setShaders(int shaderID) {
        if (shaderID >= defaultShaders.length) {
            shaderID = defaultShaders.length - 1;
        }
        if (shaderID < 0) {
            MiscUtils.setShaders(null);
        } else {
            CoreInitialiser.proxy.initShaders(defaultShaders[shaderID]);
        }
    }

    public static void setShaders(ResourceLocation shaders) {
        CoreInitialiser.proxy.initShaders(shaders);
    }
}

