/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.IClientEffectHandler;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.client.sound.SoundManager;
import org.blockartistry.mod.DynSurround.client.weather.Weather;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;
import org.blockartistry.mod.DynSurround.event.DiagnosticEvent;
import org.blockartistry.mod.DynSurround.util.PlayerUtils;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class EnvironStateHandler
implements IClientEffectHandler {
    private static final SoundEffect JUMP = ModOptions.enableJumpSound ? new SoundEffect("dsurround:jump", 0.2f, 1.0f, true) : null;
    private static final SoundEffect SWORD;
    private static final SoundEffect AXE;
    private static final SoundEffect CRAFTING;
    private static final SoundEffect BOW_PULL;
    private List<String> diagnostics;
    private int craftSoundThrottle = 0;

    @Override
    public void process(World world, EntityPlayer player) {
        EnvironState.tick(world, player);
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && ModOptions.enableDebugLogging) {
            DiagnosticEvent.Gather gather = new DiagnosticEvent.Gather(world, player);
            MinecraftForge.EVENT_BUS.post((Event)gather);
            this.diagnostics = gather.output;
        } else {
            this.diagnostics = null;
        }
    }

    @Override
    public boolean hasEvents() {
        return true;
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (JUMP == null || event.entity == null || event.entity.field_70170_p == null) {
            return;
        }
        if (event.entity.field_70170_p.field_72995_K && EnvironState.isPlayer(event.entity)) {
            SoundManager.playSoundAtPlayer(JUMP);
        }
    }

    @SubscribeEvent
    public void onItemUse(AttackEntityEvent event) {
        ItemStack currentItem;
        if (SWORD == null || event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p.field_72995_K && EnvironState.isPlayer((Entity)event.entityPlayer) && (currentItem = event.entityPlayer.func_71045_bC()) != null) {
            SoundEffect sound = null;
            Item item = currentItem.func_77973_b();
            if (item instanceof ItemSword) {
                sound = SWORD;
            } else if (item instanceof ItemAxe) {
                sound = AXE;
            }
            if (sound != null) {
                SoundManager.playSoundAtPlayer(sound);
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (CRAFTING == null || event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player.field_70170_p.field_72995_K && EnvironState.isPlayer((Entity)event.player) && this.craftSoundThrottle < EnvironState.getTickCounter() - 30) {
            this.craftSoundThrottle = EnvironState.getTickCounter();
            SoundManager.playSoundAtPlayer(CRAFTING);
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerUseItemEvent.Start event) {
        if (BOW_PULL == null || event.entityPlayer == null || event.entityPlayer.field_70170_p == null || event.item == null || event.item.func_77973_b() == null) {
            return;
        }
        if (event.entityPlayer.field_70170_p.field_72995_K && event.item.func_77973_b() instanceof ItemBow) {
            SoundManager.playSoundAtPlayer(BOW_PULL);
        }
    }

    @SubscribeEvent
    public void onGatherText(@Nonnull RenderGameOverlayEvent.Text event) {
        if (this.diagnostics != null && !this.diagnostics.isEmpty()) {
            event.left.add("");
            event.left.addAll(this.diagnostics);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void diagnostics(DiagnosticEvent.Gather event) {
        EntityPlayer player = EnvironState.getPlayer();
        event.output.add("Dim: " + EnvironState.getDimensionId() + "/" + EnvironState.getDimensionName());
        event.output.add("Player: h " + player.func_110143_aJ() + "/" + player.func_110138_aP() + "; f " + player.func_71024_bL().func_75116_a() + "; s " + player.func_71024_bL().func_75115_e());
        event.output.add(Weather.diagnostic());
        event.output.add("Biome: " + EnvironState.getBiomeName());
        event.output.add("Conditions: " + EnvironState.getConditions());
    }

    static {
        if (ModOptions.enableSwingSound) {
            SWORD = new SoundEffect("dsurround:swoosh", 1.0f, 1.0f);
            AXE = new SoundEffect("dsurround:swoosh", 1.0f, 0.5f);
        } else {
            SWORD = null;
            AXE = null;
        }
        CRAFTING = ModOptions.enableCraftingSound ? new SoundEffect("dsurround:crafting") : null;
        BOW_PULL = ModOptions.enableBowPullSound ? new SoundEffect("dsurround:bowpull") : null;
    }

    public static class EnvironState {
        public static final Random RANDOM = new XorShiftRandom();
        private static String conditions = "";
        private static String biomeName = "";
        private static BiomeGenBase playerBiome = null;
        private static DimensionRegistry dimensionInfo = null;
        private static int dimensionId;
        private static String dimensionName;
        private static EntityPlayer player;
        private static boolean freezing;
        private static boolean fog;
        private static boolean humid;
        private static boolean dry;
        private static String temperatureCategory;
        private static boolean inside;
        private static int tickCounter;
        private static final String CONDITION_TOKEN_HURT = "hurt";
        private static final String CONDITION_TOKEN_HUNGRY = "hungry";
        private static final String CONDITION_TOKEN_BURNING = "burning";
        private static final String CONDITION_TOKEN_NOAIR = "noair";
        private static final String CONDITION_TOKEN_FLYING = "flying";
        private static final String CONDITION_TOKEN_SPRINTING = "sprinting";
        private static final String CONDITION_TOKEN_INLAVA = "inlava";
        private static final String CONDITION_TOKEN_INWATER = "inwater";
        private static final String CONDITION_TOKEN_INVISIBLE = "invisible";
        private static final String CONDITION_TOKEN_BLIND = "blind";
        private static final String CONDITION_TOKEN_MINECART = "ridingminecart";
        private static final String CONDITION_TOKEN_HORSE = "ridinghorse";
        private static final String CONDITION_TOKEN_BOAT = "ridingboat";
        private static final String CONDITION_TOKEN_PIG = "ridingpig";
        private static final String CONDITION_TOKEN_RIDING = "riding";
        private static final String CONDITION_TOKEN_FREEZING = "freezing";
        private static final String CONDITION_TOKEN_FOG = "fog";
        private static final String CONDITION_TOKEN_HUMID = "humid";
        private static final String CONDITION_TOKEN_DRY = "dry";
        private static final String CONDITION_TOKEN_INSIDE = "inside";
        private static final char CONDITION_SEPARATOR = '#';

        private static String getPlayerConditions(EntityPlayer player) {
            StringBuilder builder = new StringBuilder();
            if (EnvironState.isPlayerHurt()) {
                builder.append('#').append(CONDITION_TOKEN_HURT);
            }
            if (EnvironState.isPlayerHungry()) {
                builder.append('#').append(CONDITION_TOKEN_HUNGRY);
            }
            if (EnvironState.isPlayerBurning()) {
                builder.append('#').append(CONDITION_TOKEN_BURNING);
            }
            if (EnvironState.isPlayerSuffocating()) {
                builder.append('#').append(CONDITION_TOKEN_NOAIR);
            }
            if (EnvironState.isPlayerFlying()) {
                builder.append('#').append(CONDITION_TOKEN_FLYING);
            }
            if (EnvironState.isPlayerSprinting()) {
                builder.append('#').append(CONDITION_TOKEN_SPRINTING);
            }
            if (EnvironState.isPlayerInLava()) {
                builder.append('#').append(CONDITION_TOKEN_INLAVA);
            }
            if (EnvironState.isPlayerInvisible()) {
                builder.append('#').append(CONDITION_TOKEN_INVISIBLE);
            }
            if (EnvironState.isPlayerBlind()) {
                builder.append('#').append(CONDITION_TOKEN_BLIND);
            }
            if (EnvironState.isPlayerInWater()) {
                builder.append('#').append(CONDITION_TOKEN_INWATER);
            }
            if (EnvironState.isFreezing()) {
                builder.append('#').append(CONDITION_TOKEN_FREEZING);
            }
            if (EnvironState.isFoggy()) {
                builder.append('#').append(CONDITION_TOKEN_FOG);
            }
            if (EnvironState.isHumid()) {
                builder.append('#').append(CONDITION_TOKEN_HUMID);
            }
            if (EnvironState.isDry()) {
                builder.append('#').append(CONDITION_TOKEN_DRY);
            }
            if (EnvironState.isPlayerInside()) {
                builder.append('#').append(CONDITION_TOKEN_INSIDE);
            }
            if (EnvironState.isPlayerRiding()) {
                builder.append('#');
                if (player.field_70154_o instanceof EntityMinecart) {
                    builder.append(CONDITION_TOKEN_MINECART);
                } else if (player.field_70154_o instanceof EntityHorse) {
                    builder.append(CONDITION_TOKEN_HORSE);
                } else if (player.field_70154_o instanceof EntityBoat) {
                    builder.append(CONDITION_TOKEN_BOAT);
                } else if (player.field_70154_o instanceof EntityPig) {
                    builder.append(CONDITION_TOKEN_PIG);
                } else {
                    builder.append(CONDITION_TOKEN_RIDING);
                }
            }
            builder.append('#').append(temperatureCategory);
            builder.append('#');
            return builder.toString();
        }

        private static void tick(World world, EntityPlayer player) {
            EnvironState.player = player;
            conditions = DimensionRegistry.getConditions(world) + EnvironState.getPlayerConditions(player);
            playerBiome = PlayerUtils.getPlayerBiome(player, false);
            biomeName = BiomeRegistry.resolveName(playerBiome);
            dimensionInfo = DimensionRegistry.getData(player.field_70170_p);
            dimensionId = world.field_73011_w.field_76574_g;
            dimensionName = world.field_73011_w.func_80007_l();
            inside = PlayerUtils.isReallyInside(EnvironState.player);
            int posX = MathHelper.func_76128_c((double)player.field_70165_t);
            int posY = MathHelper.func_76128_c((double)player.field_70163_u);
            int posZ = MathHelper.func_76128_c((double)player.field_70161_v);
            BiomeGenBase trueBiome = PlayerUtils.getPlayerBiome(player, true);
            freezing = trueBiome.func_150564_a(posX, posY, posZ) < 0.15f;
            temperatureCategory = "tc" + trueBiome.func_150561_m().name().toLowerCase();
            humid = trueBiome.func_76736_e();
            boolean bl = dry = trueBiome.func_76727_i() == 0.0f;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ++tickCounter;
            }
        }

        public static String getConditions() {
            return conditions;
        }

        public static BiomeGenBase getPlayerBiome() {
            return playerBiome;
        }

        public static String getBiomeName() {
            return biomeName;
        }

        public static DimensionRegistry getDimensionInfo() {
            return dimensionInfo;
        }

        public static int getDimensionId() {
            return dimensionId;
        }

        public static String getDimensionName() {
            return dimensionName;
        }

        public static EntityPlayer getPlayer() {
            if (player == null) {
                player = Minecraft.func_71410_x().field_71439_g;
            }
            return player;
        }

        public static boolean isPlayer(Entity entity) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer ep = (EntityPlayer)entity;
                return ep.func_110124_au().equals(EnvironState.getPlayer().func_110124_au());
            }
            return false;
        }

        public static boolean isPlayer(UUID id) {
            return EnvironState.getPlayer().func_110124_au().equals(id);
        }

        public static boolean isCreative() {
            return EnvironState.getPlayer().field_71075_bZ.field_75098_d;
        }

        public static boolean isPlayerHurt() {
            return !EnvironState.isCreative() && EnvironState.getPlayer().func_110143_aJ() <= (float)ModOptions.playerHurtThreshold;
        }

        public static boolean isPlayerHungry() {
            return !EnvironState.isCreative() && EnvironState.getPlayer().func_71024_bL().func_75116_a() <= ModOptions.playerHungerThreshold;
        }

        public static boolean isPlayerBurning() {
            return EnvironState.getPlayer().func_70027_ad();
        }

        public static boolean isPlayerSuffocating() {
            return EnvironState.getPlayer().func_70086_ai() <= 0;
        }

        public static boolean isPlayerFlying() {
            return EnvironState.getPlayer().field_71075_bZ.field_75100_b;
        }

        public static boolean isPlayerSprinting() {
            return EnvironState.getPlayer().func_70051_ag();
        }

        public static boolean isPlayerInLava() {
            return EnvironState.getPlayer().field_70170_p.func_72875_a(EnvironState.getPlayer().field_70121_D.func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151587_i);
        }

        public static boolean isPlayerInvisible() {
            return EnvironState.getPlayer().func_82150_aj();
        }

        public static boolean isPlayerBlind() {
            return EnvironState.getPlayer().func_70644_a(Potion.field_76440_q);
        }

        public static boolean isPlayerInWater() {
            return EnvironState.getPlayer().func_70090_H();
        }

        public static boolean isPlayerRiding() {
            return EnvironState.getPlayer().func_70115_ae();
        }

        public static boolean isPlayerOnGround() {
            return EnvironState.getPlayer().field_70122_E;
        }

        public static boolean isPlayerMoving() {
            return EnvironState.getPlayer().field_70140_Q != EnvironState.player.field_70141_P;
        }

        public static boolean isPlayerInside() {
            return inside;
        }

        public static boolean isPlayerUnderground() {
            return playerBiome == BiomeRegistry.UNDERGROUND;
        }

        public static boolean isPlayerInSpace() {
            return playerBiome == BiomeRegistry.OUTERSPACE;
        }

        public static boolean isPlayerInClouds() {
            return playerBiome == BiomeRegistry.CLOUDS;
        }

        public static boolean isFreezing() {
            return freezing;
        }

        public static boolean isFoggy() {
            return fog;
        }

        public static boolean isHumid() {
            return humid;
        }

        public static boolean isDry() {
            return dry;
        }

        public static World getWorld() {
            return EnvironState.getPlayer().field_70170_p;
        }

        public static int getTickCounter() {
            return tickCounter;
        }

        public static double distanceToPlayer(double x, double y, double z) {
            if (player == null) {
                return Double.MAX_VALUE;
            }
            return player.func_70092_e(x, y, z);
        }

        static {
            temperatureCategory = "";
        }
    }
}

