/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.fog;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.ForgeModContainer;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.fog.VanillaFogColorCalculator;
import org.blockartistry.mod.DynSurround.client.weather.Weather;
import org.blockartistry.mod.DynSurround.compat.BlockPos;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.util.Color;
import org.blockartistry.mod.DynSurround.util.MathStuff;

@SideOnly(value=Side.CLIENT)
public class BiomeFogColorCalculator
extends VanillaFogColorCalculator {
    protected int posX;
    protected int posZ;
    protected double weightBiomeFog;
    protected Color biomeFogColor;
    protected boolean doScan = true;

    @Override
    @Nonnull
    public Color calculate(@Nonnull EntityViewRenderEvent.FogColors event) {
        float thunderStrength;
        EntityPlayer player = EnvironStateHandler.EnvironState.getPlayer();
        World world = EnvironStateHandler.EnvironState.getWorld();
        int playerX = MathStuff.floor(player.field_70165_t);
        int playerZ = MathStuff.floor(player.field_70161_v);
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 6;
        if (settings.field_74347_j && ranges.length > 0) {
            distance = ranges[MathStuff.clamp(settings.field_151451_c, 0, ranges.length - 1)];
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
        this.doScan |= this.posX != playerX || this.posZ != playerZ;
        if (this.doScan) {
            this.doScan = false;
            this.posX = playerX;
            this.posZ = playerZ;
            this.biomeFogColor = new Color(0, 0, 0);
            this.weightBiomeFog = 0.0;
            for (int x = -distance; x <= distance; ++x) {
                for (int z = -distance; z <= distance; ++z) {
                    pos.setPos(playerX + x, 0, playerZ + z);
                    this.doScan |= world.func_72899_e(pos.getX(), pos.getY(), pos.getZ());
                    BiomeGenBase biome = world.func_72807_a(pos.getX(), pos.getZ());
                    Color color = BiomeRegistry.hasDust(biome) ? BiomeRegistry.getDustColor(biome) : (BiomeRegistry.hasFog(biome) ? BiomeRegistry.getFogColor(biome) : null);
                    if (color == null) continue;
                    this.biomeFogColor.add(color);
                    this.weightBiomeFog += 1.0;
                }
            }
        }
        if (this.weightBiomeFog == 0.0 || distance == 0) {
            return super.calculate(event);
        }
        float partialTicks = (float)event.renderPartialTicks;
        float celestialAngle = world.func_72826_c(partialTicks);
        float baseScale = MathStuff.clamp(MathStuff.cos(celestialAngle * (float)Math.PI * 2.0f) * 2.0f + 0.5f, 0.0f, 1.0f);
        double rScale = baseScale * 0.94f + 0.06f;
        double gScale = baseScale * 0.94f + 0.06f;
        double bScale = baseScale * 0.91f + 0.09f;
        float rainStrength = Weather.getIntensityLevel();
        if (rainStrength > 0.0f) {
            rScale *= (double)(1.0f - rainStrength * 0.5f);
            gScale *= (double)(1.0f - rainStrength * 0.5f);
            bScale *= (double)(1.0f - rainStrength * 0.4f);
        }
        if ((thunderStrength = Weather.getThunderStrength()) > 0.0f) {
            rScale *= (double)(1.0f - thunderStrength * 0.5f);
            gScale *= (double)(1.0f - thunderStrength * 0.5f);
            bScale *= (double)(1.0f - thunderStrength * 0.5f);
        }
        Color fogColor = new Color(this.biomeFogColor);
        fogColor.scale((float)(rScale / this.weightBiomeFog), (float)(gScale / this.weightBiomeFog), (float)(bScale / this.weightBiomeFog));
        Color processedColor = this.applyPlayerEffects(world, (EntityLivingBase)player, fogColor, partialTicks);
        double weightMixed = (distance * 2 + 1) * (distance * 2 + 1);
        double weightDefault = weightMixed - this.weightBiomeFog;
        Color vanillaColor = super.calculate(event);
        processedColor.scale((float)this.weightBiomeFog);
        vanillaColor.scale((float)weightDefault);
        return processedColor.add(vanillaColor).scale((float)(1.0 / weightMixed));
    }

    protected Color applyPlayerEffects(@Nonnull World world, @Nonnull EntityLivingBase player, @Nonnull Color fogColor, float renderPartialTicks) {
        int duration;
        float darkScale = (float)((player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)renderPartialTicks) * world.field_73011_w.func_76565_k());
        if (player.func_70644_a(Potion.field_76440_q)) {
            duration = player.func_70660_b(Potion.field_76440_q).func_76459_b();
            darkScale *= duration < 20 ? 1.0f - (float)duration / 20.0f : 0.0f;
        }
        if (darkScale < 1.0f) {
            darkScale = darkScale < 0.0f ? 0.0f : darkScale * darkScale;
            fogColor.scale(darkScale);
        }
        if (player.func_70644_a(Potion.field_76439_r)) {
            duration = player.func_70660_b(Potion.field_76439_r).func_76459_b();
            float brightness = duration > 200 ? 1.0f : 0.7f + MathStuff.sin(((float)duration - renderPartialTicks) * (float)Math.PI * 0.2f) * 0.3f;
            float scale = 1.0f / fogColor.red;
            scale = Math.min(scale, 1.0f / fogColor.green);
            scale = Math.min(scale, 1.0f / fogColor.blue);
            return fogColor.scale(1.0f - brightness + scale * brightness);
        }
        return fogColor;
    }
}

