/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.fog;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.fog.FogResult;
import org.blockartistry.mod.DynSurround.client.fog.VanillaFogRangeCalculator;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;

@SideOnly(value=Side.CLIENT)
public class HazeFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final int BAND_OFFSETS = 15;
    protected static final int BAND_CORE_SIZE = 10;
    protected static final float IMPACT_FAR = 0.6f;
    protected static final float IMPACT_NEAR = 0.95f;
    protected final FogResult cached = new FogResult();

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        DimensionRegistry di = EnvironStateHandler.EnvironState.getDimensionInfo();
        if (di == null) {
            this.cached.set(event);
            return this.cached;
        }
        if (di.getHasHaze()) {
            float lowY = di.getCloudHeight() - 15;
            float highY = di.getCloudHeight() + 15 + 10;
            double eyeHeight = EnvironStateHandler.EnvironState.getPlayer().field_70163_u + (double)EnvironStateHandler.EnvironState.getPlayer().eyeHeight;
            if (eyeHeight >= (double)lowY && eyeHeight <= (double)highY) {
                float factor;
                float coreLowY = lowY + 15.0f;
                float coreHighY = coreLowY + 10.0f;
                float scaleFar = 0.6f;
                float scaleNear = 0.95f;
                if (eyeHeight < (double)coreLowY) {
                    factor = (float)((eyeHeight - (double)lowY) / 15.0);
                    scaleFar *= factor;
                    scaleNear *= factor;
                } else if (eyeHeight > (double)coreHighY) {
                    factor = (float)(((double)highY - eyeHeight) / 15.0);
                    scaleFar *= factor;
                    scaleNear *= factor;
                }
                float end = event.farPlaneDistance * (1.0f - scaleFar);
                float start = event.farPlaneDistance * (1.0f - scaleNear);
                this.cached.set(start, end);
                return this.cached;
            }
        }
        this.cached.set(event);
        return this.cached;
    }
}

