/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.game.system;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.EventType;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.Association;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.NormalVariator;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IGenerator;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IIsolator;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.ISolver;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IVariator;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IVariatorSettable;
import org.blockartistry.mod.DynSurround.util.MyUtils;

@SideOnly(value=Side.CLIENT)
public class PFReaderH
implements IGenerator,
IVariatorSettable {
    protected final IIsolator mod;
    protected NormalVariator VAR;
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected boolean isFlying;
    protected float fallDistance;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected boolean isRightFoot;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    private boolean stepThisFrame;
    private boolean isMessyFoliage;
    private long brushesTime;

    public PFReaderH(IIsolator isolator) {
        this.mod = isolator;
        this.VAR = new NormalVariator();
    }

    @Override
    public void setVariator(IVariator variator) {
        if (variator instanceof NormalVariator) {
            this.VAR = (NormalVariator)variator;
        }
    }

    @Override
    public void generateFootsteps(EntityPlayer ply) {
        this.simulateFootsteps(ply);
        this.simulateAirborne(ply);
        this.simulateBrushes(ply);
    }

    protected boolean stoppedImmobile(float reference) {
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = MyUtils.currentTimeMillis();
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return MyUtils.currentTimeMillis() - this.timeImmobile > (long)this.VAR.IMMOBILE_DURATION;
        }
        return false;
    }

    protected void simulateFootsteps(EntityPlayer ply) {
        double movZ;
        double movX;
        double scal;
        float distanceReference = ply.field_82151_R;
        this.stepThisFrame = false;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = ply.field_70159_w) * this.xMovec + (movZ = ply.field_70179_y) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.VAR.PLAY_WANDER && !this.mod.getSolver().hasSpecialStoppingConditions(ply)) {
                this.mod.getSolver().playAssociation(ply, this.mod.getSolver().findAssociationForPlayer(ply, 0.0, this.isRightFoot), EventType.WANDER);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        if (ply.field_70122_E || ply.func_70090_H() || ply.func_70617_f_()) {
            EventType event = null;
            float dwm = distanceReference - this.dmwBase;
            boolean immobile = this.stoppedImmobile(distanceReference);
            if (immobile && !ply.func_70617_f_()) {
                dwm = 0.0f;
                this.dmwBase = distanceReference;
            }
            float distance = 0.0f;
            double verticalOffsetAsMinus = 0.0;
            if (ply.func_70617_f_() && !ply.field_70122_E) {
                distance = this.VAR.DISTANCE_LADDER;
            } else if (!ply.func_70090_H() && Math.abs(this.yPosition - ply.field_70163_u) > 0.4) {
                if (this.yPosition < ply.field_70163_u) {
                    distance = this.VAR.DISTANCE_STAIR;
                    event = this.speedDisambiguator(ply, EventType.UP, EventType.UP_RUN);
                } else if (!ply.func_70093_af()) {
                    distance = -1.0f;
                    verticalOffsetAsMinus = 0.0;
                    event = this.speedDisambiguator(ply, EventType.DOWN, EventType.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = this.VAR.DISTANCE_HUMAN;
            }
            if (event == null) {
                event = this.speedDisambiguator(ply, EventType.WALK, EventType.RUN);
            }
            if (dwm > (distance = this.reevaluateDistance(event, distance))) {
                this.produceStep(ply, event, verticalOffsetAsMinus);
                this.stepped(ply, event);
                this.dmwBase = distanceReference;
            }
        }
        if (ply.field_70122_E) {
            this.yPosition = ply.field_70163_u;
        }
    }

    protected void produceStep(EntityPlayer ply, EventType event) {
        this.produceStep(ply, event, 0.0);
    }

    protected void produceStep(EntityPlayer ply, EventType event, double verticalOffsetAsMinus) {
        if (!this.mod.getSolver().playSpecialStoppingConditions(ply)) {
            if (event == null) {
                event = this.speedDisambiguator(ply, EventType.WALK, EventType.RUN);
            }
            this.mod.getSolver().playAssociation(ply, this.mod.getSolver().findAssociationForPlayer(ply, verticalOffsetAsMinus, this.isRightFoot), event);
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected void stepped(EntityPlayer ply, EventType event) {
    }

    protected float reevaluateDistance(EventType event, float distance) {
        return distance;
    }

    protected void simulateAirborne(EntityPlayer ply) {
        if ((ply.field_70122_E || ply.func_70617_f_()) == this.isFlying) {
            this.isFlying = !this.isFlying;
            this.simulateJumpingLanding(ply);
        }
        if (this.isFlying) {
            this.fallDistance = ply.field_70143_R;
        }
    }

    protected void simulateJumpingLanding(EntityPlayer ply) {
        if (this.mod.getSolver().hasSpecialStoppingConditions(ply)) {
            return;
        }
        boolean isJumping = ply.field_70703_bu;
        if (this.isFlying && isJumping) {
            if (this.VAR.EVENT_ON_JUMP) {
                double speed = ply.field_70159_w * ply.field_70159_w + ply.field_70179_y * ply.field_70179_y;
                if (speed < (double)this.VAR.SPEED_TO_JUMP_AS_MULTIFOOT) {
                    this.playMultifoot(ply, 0.4, EventType.JUMP);
                } else {
                    this.playSinglefoot(ply, 0.4, EventType.JUMP, this.isRightFoot);
                }
            }
        } else if (!this.isFlying) {
            if (this.fallDistance > this.VAR.LAND_HARD_DISTANCE_MIN) {
                this.playMultifoot(ply, 0.0, EventType.LAND);
            } else if (!this.stepThisFrame && !ply.func_70093_af()) {
                this.playSinglefoot(ply, 0.0, this.speedDisambiguator(ply, EventType.CLIMB, EventType.CLIMB_RUN), this.isRightFoot);
                this.isRightFoot = !this.isRightFoot;
            }
        }
    }

    protected EventType speedDisambiguator(EntityPlayer ply, EventType walk, EventType run) {
        double velocity = ply.field_70159_w * ply.field_70159_w + ply.field_70179_y * ply.field_70179_y;
        return velocity > (double)this.VAR.SPEED_TO_RUN ? run : walk;
    }

    private void simulateBrushes(EntityPlayer ply) {
        if (this.brushesTime > MyUtils.currentTimeMillis()) {
            return;
        }
        this.brushesTime = MyUtils.currentTimeMillis() + 100L;
        if (ply.field_70159_w == 0.0 && ply.field_70179_y == 0.0 || ply.func_70093_af()) {
            return;
        }
        int yy = MathHelper.func_76128_c((double)(ply.field_70163_u - 0.1 - ply.func_70033_W() - (ply.field_70122_E ? 0.0 : 0.25)));
        Association assos = this.mod.getSolver().findAssociationForBlock(MathHelper.func_76128_c((double)ply.field_70165_t), yy, MathHelper.func_76128_c((double)ply.field_70161_v), "find_messy_foliage");
        if (assos != null) {
            if (!this.isMessyFoliage) {
                this.isMessyFoliage = true;
                this.mod.getSolver().playAssociation(ply, assos, EventType.WALK);
            }
        } else {
            this.isMessyFoliage = false;
        }
    }

    protected void playSinglefoot(EntityPlayer ply, double verticalOffsetAsMinus, EventType eventType, boolean foot) {
        Association assos = this.mod.getSolver().findAssociationForPlayer(ply, verticalOffsetAsMinus, this.isRightFoot);
        this.mod.getSolver().playAssociation(ply, assos, eventType);
    }

    protected void playMultifoot(EntityPlayer ply, double verticalOffsetAsMinus, EventType eventType) {
        ISolver s = this.mod.getSolver();
        Association leftFoot = s.findAssociationForPlayer(ply, verticalOffsetAsMinus, false);
        Association rightFoot = s.findAssociationForPlayer(ply, verticalOffsetAsMinus, true);
        s.playAssociation(ply, leftFoot, eventType);
        s.playAssociation(ply, rightFoot, eventType);
    }

    protected float scalex(float number, float min, float max) {
        return MathHelper.func_76131_a((float)((number - min) / (max - min)), (float)0.0f, (float)1.0f);
    }
}

