/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.footsteps.game.system;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.implem.ConfigOptions;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.EventType;
import org.blockartistry.mod.DynSurround.client.footsteps.engine.interfaces.IOptions;
import org.blockartistry.mod.DynSurround.client.footsteps.game.system.Association;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.implem.Substrate;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.IIsolator;
import org.blockartistry.mod.DynSurround.client.footsteps.mcpackage.interfaces.ISolver;
import org.blockartistry.mod.DynSurround.util.MathStuff;

@SideOnly(value=Side.CLIENT)
public class PFSolver
implements ISolver {
    private final IIsolator isolator;

    public PFSolver(IIsolator isolator) {
        this.isolator = isolator;
    }

    @Override
    public void playAssociation(EntityPlayer ply, Association assos, EventType eventType) {
        if (assos != null && !assos.isNotEmitter()) {
            if (assos.getNoAssociation()) {
                this.isolator.getDefaultStepPlayer().playStep((EntityLivingBase)ply, assos);
            } else {
                this.isolator.getAcoustics().playAcoustic(ply, assos, eventType);
            }
        }
    }

    @Override
    public Association findAssociationForPlayer(EntityPlayer ply, double verticalOffsetAsMinus, boolean isRightFoot) {
        if (Math.abs(ply.field_70181_x) < 0.02) {
            return null;
        }
        int yy = MathHelper.func_76128_c((double)(ply.field_70121_D.field_72338_b - 0.1 - verticalOffsetAsMinus));
        double rot = MathStuff.toRadians(MathHelper.func_76142_g((float)ply.field_70177_z));
        double xn = MathStuff.cos(rot);
        double zn = MathStuff.sin(rot);
        float feetDistanceToCenter = 0.2f * (float)(isRightFoot ? -1 : 1);
        int xx = MathHelper.func_76128_c((double)(ply.field_70165_t + xn * (double)feetDistanceToCenter));
        int zz = MathHelper.func_76128_c((double)(ply.field_70161_v + zn * (double)feetDistanceToCenter));
        return this.findAssociationForLocation(ply, xx, yy, zz);
    }

    @Override
    public Association findAssociationForPlayer(EntityPlayer ply, double verticalOffsetAsMinus) {
        int yy = MathHelper.func_76128_c((double)(ply.field_70163_u - 0.1 - ply.func_70033_W() - verticalOffsetAsMinus));
        int xx = MathHelper.func_76128_c((double)ply.field_70165_t);
        int zz = MathHelper.func_76128_c((double)ply.field_70161_v);
        return this.findAssociationForLocation(ply, xx, yy, zz);
    }

    @Override
    public Association findAssociationForLocation(EntityPlayer player, int x, int y, int z) {
        Association worked;
        if (player.func_70090_H()) {
            ModLog.debug("WARNING!!! Playing a sound while in the water! This is supposed to be halted by the stopping conditions!!", new Object[0]);
        }
        if ((worked = this.findAssociationForBlock(x, y, z)) == null) {
            double xdang = (player.field_70165_t - (double)x) * 2.0 - 1.0;
            double zdang = (player.field_70161_v - (double)z) * 2.0 - 1.0;
            if (Math.max(Math.abs(xdang), Math.abs(zdang)) > (double)0.2f) {
                boolean isXdangMax;
                boolean bl = isXdangMax = Math.abs(xdang) > Math.abs(zdang);
                worked = isXdangMax ? this.findAssociationForBlock(xdang > 0.0 ? x + 1 : x - 1, y, z) : this.findAssociationForBlock(x, y, zdang > 0.0 ? z + 1 : z - 1);
                if (worked == null) {
                    worked = isXdangMax ? this.findAssociationForBlock(x, y, zdang > 0.0 ? z + 1 : z - 1) : this.findAssociationForBlock(xdang > 0.0 ? x + 1 : x - 1, y, z);
                }
            }
        }
        return worked;
    }

    @Override
    public Association findAssociationForBlock(int xx, int yy, int zz) {
        World world = EnvironStateHandler.EnvironState.getWorld();
        Block in = world.func_147439_a(xx, yy, zz);
        int inMeta = world.func_72805_g(xx, yy, zz);
        Block above = world.func_147439_a(xx, yy + 1, zz);
        int aboveMeta = world.func_72805_g(xx, yy + 1, zz);
        String association = null;
        if (above != Blocks.field_150350_a) {
            association = this.isolator.getBlockMap().getBlockMapSubstrate(above, aboveMeta, Substrate.CARPET);
        }
        if (association == null || association.equals("NOT_EMITTER")) {
            String foliage;
            if (in == Blocks.field_150350_a) {
                Block below = world.func_147439_a(xx, yy - 1, zz);
                int belowMeta = world.func_72805_g(xx, yy - 1, zz);
                association = this.isolator.getBlockMap().getBlockMapSubstrate(below, belowMeta, Substrate.FENCE);
                if (association != null) {
                    --yy;
                    in = below;
                    ModLog.debug("Fence detected: " + association, new Object[0]);
                }
            }
            if (association == null) {
                association = this.isolator.getBlockMap().getBlockMap(in, inMeta);
            }
            if (association != null && !association.equals("NOT_EMITTER") && above != Blocks.field_150350_a && (foliage = this.isolator.getBlockMap().getBlockMapSubstrate(above, aboveMeta, Substrate.FOLIAGE)) != null && !foliage.equals("NOT_EMITTER")) {
                association = association + "," + foliage;
                ModLog.debug("Foliage detected: " + foliage, new Object[0]);
            }
        } else {
            ++yy;
            in = above;
            ModLog.debug("Carpet detected: " + association, new Object[0]);
        }
        if (association != null) {
            if (association.equals("NOT_EMITTER")) {
                return null;
            }
            return new Association(in, inMeta, xx, yy, zz).setAssociation(association);
        }
        String primitive = this.resolvePrimitive(in);
        if (primitive != null) {
            if (primitive.equals("NOT_EMITTER")) {
                return null;
            }
            return new Association(in, inMeta, xx, yy, zz).setPrimitive(primitive);
        }
        return new Association(in, inMeta, xx, yy, zz).setNoAssociation();
    }

    private String resolvePrimitive(Block block) {
        if (block == Blocks.field_150350_a || block.field_149762_H == null) {
            return "NOT_EMITTER";
        }
        String soundName = block.field_149762_H.field_150501_a;
        if (soundName == null || soundName.isEmpty()) {
            return "NOT_EMITTER";
        }
        String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(block.field_149762_H.field_150499_b), Float.valueOf(block.field_149762_H.field_150500_c));
        String primitive = this.isolator.getPrimitiveMap().getPrimitiveMapSubstrate(soundName, substrate);
        if (primitive == null) {
            if (block.field_149762_H.field_150501_a != null) {
                primitive = this.isolator.getPrimitiveMap().getPrimitiveMapSubstrate(soundName, "break_" + soundName);
            }
            if (primitive == null) {
                primitive = this.isolator.getPrimitiveMap().getPrimitiveMap(soundName);
            }
        }
        if (primitive != null) {
            ModLog.debug("Primitive found for " + soundName + ":" + substrate, new Object[0]);
            return primitive;
        }
        ModLog.debug("No primitive for " + soundName + ":" + substrate, new Object[0]);
        return null;
    }

    @Override
    public boolean playSpecialStoppingConditions(EntityPlayer ply) {
        if (ply.func_70090_H()) {
            float volume = MathHelper.func_76133_a((double)(ply.field_70159_w * ply.field_70159_w * 0.2 + ply.field_70181_x * ply.field_70181_x + ply.field_70179_y * ply.field_70179_y * 0.2)) * 0.35f;
            ConfigOptions options = new ConfigOptions();
            options.getMap().put(IOptions.Option.GLIDING_VOLUME, Float.valueOf(volume > 1.0f ? 1.0f : volume));
            this.isolator.getAcoustics().playAcoustic(ply, "_SWIM", ply.func_70055_a(Material.field_151586_h) ? EventType.SWIM : EventType.WALK, options);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSpecialStoppingConditions(EntityPlayer ply) {
        return ply.func_70090_H();
    }

    @Override
    public Association findAssociationForBlock(int xx, int yy, int zz, String strategy) {
        if (!strategy.equals("find_messy_foliage")) {
            return null;
        }
        World world = EnvironStateHandler.EnvironState.getWorld();
        Block above = world.func_147439_a(xx, yy + 1, zz);
        if (above == Blocks.field_150350_a) {
            return null;
        }
        int aboveMeta = world.func_72805_g(xx, yy + 1, zz);
        String association = null;
        boolean found = false;
        String foliage = this.isolator.getBlockMap().getBlockMapSubstrate(above, aboveMeta, Substrate.FOLIAGE);
        if (foliage != null && !foliage.equals("NOT_EMITTER")) {
            association = foliage;
            String isMessy = this.isolator.getBlockMap().getBlockMapSubstrate(above, aboveMeta, Substrate.MESSY);
            if (isMessy != null && isMessy.equals("MESSY_GROUND")) {
                found = true;
            }
        }
        if (found && association != null) {
            return association.equals("NOT_EMITTER") ? null : new Association().setAssociation(association);
        }
        return null;
    }
}

