/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.weather;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.weather.StormRenderer;

@SideOnly(value=Side.CLIENT)
public enum Weather {
    VANILLA,
    NONE(0.0f, "calm"),
    CALM(0.1f, "calm"),
    LIGHT(0.33f, "light"),
    NORMAL(0.66f, "normal"),
    HEAVY(1.0f, "heavy");

    private static float intensityLevel;
    private static Weather intensity;
    private final float level;
    private final ResourceLocation rainTexture;
    private final ResourceLocation snowTexture;
    private final ResourceLocation dustTexture;
    private final String rainSound;
    private final String dustSound;

    private Weather() {
        this.level = -10.0f;
        this.rainTexture = EntityRenderer.field_110924_q;
        this.snowTexture = EntityRenderer.field_110923_r;
        this.dustTexture = new ResourceLocation("dsurround", "textures/environment/dust_calm.png");
        this.rainSound = String.format("%s:%s", "dsurround", "rain");
        this.dustSound = String.format("%s:%s", "dsurround", "dust");
    }

    private Weather(float level, String intensity) {
        this.level = level;
        this.rainTexture = new ResourceLocation("dsurround", String.format("textures/environment/rain_%s.png", intensity));
        this.snowTexture = new ResourceLocation("dsurround", String.format("textures/environment/snow_%s.png", intensity));
        this.dustTexture = new ResourceLocation("dsurround", String.format("textures/environment/dust_%s.png", intensity));
        this.rainSound = String.format("%s:%s", "dsurround", "rain");
        this.dustSound = String.format("%s:%s", "dsurround", "dust");
    }

    private static World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static Weather getIntensity() {
        return intensity;
    }

    public static float getIntensityLevel() {
        return Math.min(Weather.getWorld().field_73004_o, intensityLevel);
    }

    public static float getMaxIntensityLevel() {
        return intensityLevel;
    }

    public static boolean isRaining() {
        return Weather.getIntensityLevel() > 0.0f;
    }

    public static float getRainStrength() {
        return Weather.getWorld().field_73004_o;
    }

    public static float getThunderStrength() {
        return Weather.getWorld().field_73017_q;
    }

    public String getStormSound() {
        return this.rainSound;
    }

    public String getDustSound() {
        return this.dustSound;
    }

    public static float getCurrentVolume() {
        return (Weather.doVanilla() ? 0.66f : intensityLevel) * ModOptions.soundLevel;
    }

    public static ResourceLocation getCurrentStormSound() {
        return new ResourceLocation(Weather.intensity.rainSound);
    }

    public static ResourceLocation getCurrentDustSound() {
        return new ResourceLocation(Weather.intensity.dustSound);
    }

    public static boolean doVanilla() {
        return intensity == VANILLA || ModOptions.disableWeatherEffects;
    }

    public static void setIntensity(float level) {
        if (level == Weather.VANILLA.level) {
            intensity = VANILLA;
            intensityLevel = 0.0f;
            Weather.setTextures();
            return;
        }
        if (intensityLevel != (level = MathHelper.func_76131_a((float)level, (float)0.0f, (float)1.0f))) {
            intensityLevel = level;
            if (level > 0.0f) {
                level = (float)((double)level + 0.01);
            }
            intensity = intensityLevel <= Weather.NONE.level ? NONE : (intensityLevel < Weather.CALM.level ? CALM : (intensityLevel < Weather.LIGHT.level ? LIGHT : (intensityLevel < Weather.NORMAL.level ? NORMAL : HEAVY)));
        }
    }

    public static void setTextures() {
        StormRenderer.locationRainPng = Weather.intensity.rainTexture;
        StormRenderer.locationSnowPng = Weather.intensity.snowTexture;
        StormRenderer.locationDustPng = Weather.intensity.dustTexture;
    }

    public static String diagnostic() {
        StringBuilder builder = new StringBuilder();
        builder.append("Storm: ").append(intensity.name());
        builder.append(" level:").append(intensityLevel);
        builder.append(" str:").append(EnvironStateHandler.EnvironState.getWorld().func_72867_j(1.0f));
        return builder.toString();
    }

    static {
        intensityLevel = 0.0f;
        intensity = VANILLA;
    }
}

