/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.data;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.Module;
import org.blockartistry.mod.DynSurround.client.fx.BlockEffect;
import org.blockartistry.mod.DynSurround.client.fx.JetEffect;
import org.blockartistry.mod.DynSurround.client.sound.SoundEffect;
import org.blockartistry.mod.DynSurround.data.SoundRegistry;
import org.blockartistry.mod.DynSurround.data.config.BlockConfig;
import org.blockartistry.mod.DynSurround.data.config.SoundConfig;

public final class BlockRegistry {
    private static final Map<Block, Entry> registry = new IdentityHashMap<Block, Entry>();

    public static void initialize() {
        registry.clear();
        BlockRegistry.processConfig();
        if (ModOptions.enableDebugLogging) {
            ModLog.info("*** BLOCK REGISTRY ***", new Object[0]);
            for (Entry entry : registry.values()) {
                ModLog.info(entry.toString(), new Object[0]);
            }
        }
    }

    public static List<BlockEffect> getEffects(Block block) {
        Entry entry = registry.get(block);
        return entry != null ? entry.effects : null;
    }

    private static SoundEffect getRandomSound(List<SoundEffect> list, Random random, String conditions) {
        int totalWeight = 0;
        ArrayList<SoundEffect> candidates = new ArrayList<SoundEffect>();
        for (SoundEffect s : list) {
            if (!s.matches(conditions)) continue;
            candidates.add(s);
            totalWeight += s.weight;
        }
        if (totalWeight <= 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (SoundEffect)candidates.get(0);
        }
        int targetWeight = random.nextInt(totalWeight);
        int i = 0;
        i = candidates.size();
        while ((targetWeight -= ((SoundEffect)candidates.get((int)(i - 1))).weight) >= 0) {
            --i;
        }
        return (SoundEffect)candidates.get(i - 1);
    }

    public static SoundEffect getSound(Block block, Random random, String conditions) {
        Entry entry = registry.get(block);
        if (entry == null || entry.sounds.isEmpty() || random.nextInt(entry.chance) != 0) {
            return null;
        }
        return BlockRegistry.getRandomSound(entry.sounds, random, conditions);
    }

    public static SoundEffect getStepSound(Block block, Random random, String conditions) {
        Entry entry = registry.get(block);
        if (entry == null || entry.stepSounds.isEmpty() || random.nextInt(entry.stepChance) != 0) {
            return null;
        }
        return BlockRegistry.getRandomSound(entry.stepSounds, random, conditions);
    }

    private static void processConfig() {
        String[] configFiles;
        try {
            BlockRegistry.process(BlockConfig.load("blocks"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            try {
                BlockRegistry.process(BlockConfig.load(mod.getModId() + "_blocks"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String file : configFiles = ModOptions.blockConfigFiles) {
            File theFile = new File(Module.dataDirectory(), file);
            if (theFile.exists()) {
                try {
                    BlockConfig config = BlockConfig.load(theFile);
                    if (config != null) {
                        BlockRegistry.process(config);
                        continue;
                    }
                    ModLog.warn("Unable to process block config file " + file, new Object[0]);
                }
                catch (Exception ex) {
                    ModLog.error("Unable to process block config file " + file, ex);
                }
                continue;
            }
            ModLog.warn("Could not locate block config file [%s]", file);
        }
    }

    private static void process(BlockConfig config) {
        for (BlockConfig.Entry entry : config.entries) {
            if (entry.blocks.isEmpty()) continue;
            for (String blockName : entry.blocks) {
                Block block = (Block)GameData.getBlockRegistry().func_82594_a(blockName);
                if (block == null || block == Blocks.field_150350_a) {
                    ModLog.warn("Unknown block [%s] in block config file", blockName);
                    continue;
                }
                Entry blockData = registry.get(block);
                if (blockData == null) {
                    blockData = new Entry(block);
                    registry.put(block, blockData);
                }
                if (entry.soundReset != null && entry.soundReset.booleanValue()) {
                    blockData.sounds.clear();
                }
                if (entry.stepSoundReset != null && entry.stepSoundReset.booleanValue()) {
                    blockData.stepSounds.clear();
                }
                if (entry.effectReset != null && entry.effectReset.booleanValue()) {
                    blockData.effects.clear();
                }
                if (entry.chance != null) {
                    blockData.chance = entry.chance;
                }
                if (entry.stepChance != null) {
                    blockData.stepChance = entry.stepChance;
                }
                for (SoundConfig sr : entry.sounds) {
                    if (sr.sound == null || SoundRegistry.isSoundBlocked(sr.sound)) continue;
                    SoundEffect eff = new SoundEffect(sr);
                    if (eff.type == SoundEffect.SoundType.STEP) {
                        blockData.stepSounds.add(eff);
                        continue;
                    }
                    blockData.sounds.add(eff);
                }
                for (BlockConfig.Effect e : entry.effects) {
                    int chance;
                    if (StringUtils.isEmpty((CharSequence)e.effect)) continue;
                    JetEffect blockEffect = null;
                    int n = chance = e.chance != null ? e.chance : 100;
                    if (StringUtils.equalsIgnoreCase((CharSequence)"steam", (CharSequence)e.effect)) {
                        blockEffect = new JetEffect.Steam(chance);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)"fire", (CharSequence)e.effect)) {
                        blockEffect = new JetEffect.Fire(chance);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)"bubble", (CharSequence)e.effect)) {
                        blockEffect = new JetEffect.Bubble(chance);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)"dust", (CharSequence)e.effect)) {
                        blockEffect = new JetEffect.Dust(chance);
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)"fountain", (CharSequence)e.effect)) {
                        blockEffect = new JetEffect.Fountain(chance);
                    } else {
                        ModLog.warn("Unknown effect type in config: '%s'", e.effect);
                        continue;
                    }
                    blockData.effects.add(blockEffect);
                }
            }
        }
    }

    private static final class Entry {
        public final Block block;
        public int chance = 100;
        public int stepChance = 100;
        public final List<SoundEffect> sounds = new ArrayList<SoundEffect>();
        public final List<SoundEffect> stepSounds = new ArrayList<SoundEffect>();
        public final List<BlockEffect> effects = new ArrayList<BlockEffect>();

        public Entry(Block block) {
            this.block = block;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("Block [%s]:", this.block.func_149739_a()));
            if (!this.sounds.isEmpty()) {
                builder.append(" chance:").append(this.chance);
                builder.append("; sounds [");
                for (SoundEffect sound : this.sounds) {
                    builder.append(sound.toString()).append(',');
                }
                builder.append(']');
            }
            if (!this.stepSounds.isEmpty()) {
                builder.append(" chance:").append(this.stepChance);
                builder.append("; step sounds [");
                for (SoundEffect sound : this.stepSounds) {
                    builder.append(sound.toString()).append(',');
                }
                builder.append(']');
            }
            if (!this.effects.isEmpty()) {
                builder.append("; effects [");
                for (BlockEffect effect : this.effects) {
                    builder.append(effect.toString()).append(',');
                }
                builder.append(']');
            }
            return builder.toString();
        }
    }
}

