/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.blockartistry.mod.DynSurround.ModLog;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.data.AuroraData;
import org.blockartistry.mod.DynSurround.data.AuroraPreset;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.data.ColorPair;
import org.blockartistry.mod.DynSurround.data.DimensionEffectData;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;
import org.blockartistry.mod.DynSurround.network.Network;
import org.blockartistry.mod.DynSurround.util.DiurnalUtils;
import org.blockartistry.mod.DynSurround.util.PlayerUtils;

public final class ServerEffectHandler {
    private static final float RESET = -10.0f;
    private static final long MIN_AURORA_DISTANCE_SQ = 160000L;
    private static final int CHECK_INTERVAL = 100;
    private static TIntIntHashMap tickCounters = new TIntIntHashMap();

    public static void initialize() {
        FMLCommonHandler.instance().bus().register((Object)new ServerEffectHandler());
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (ModOptions.auroraEnable) {
                this.processAuroras(event);
            }
            return;
        }
        if (!ModOptions.disableWeatherEffects) {
            World world = event.world;
            int dimensionId = world.field_73011_w.field_76574_g;
            float sendIntensity = DimensionRegistry.hasWeather(world) ? DimensionEffectData.get(world).getRainIntensity() : -10.0f;
            Network.sendRainIntensity(sendIntensity, dimensionId);
        }
    }

    private static boolean isAuroraInRange(EntityPlayerMP player, Set<AuroraData> data) {
        for (AuroraData aurora : data) {
            long deltaX = aurora.posX - (int)player.field_70165_t;
            long deltaZ = aurora.posZ - (int)player.field_70161_v + -ModOptions.auroraSpawnOffset;
            long distSq = deltaX * deltaX + deltaZ * deltaZ;
            if (distSq > 160000L) continue;
            return true;
        }
        return false;
    }

    private static boolean okToSpawnAurora(World world) {
        return DiurnalUtils.isNighttime(world);
    }

    protected void processAuroras(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world == null || !DimensionRegistry.hasAuroras(world)) {
            return;
        }
        Set<AuroraData> data = DimensionEffectData.get(world).getAuroraList();
        if (DiurnalUtils.isDaytime(world)) {
            data.clear();
        } else {
            int tickCount = tickCounters.get(world.field_73011_w.field_76574_g) + 1;
            tickCounters.put(world.field_73011_w.field_76574_g, tickCount);
            if (tickCount % 100 == 0) {
                if (ServerEffectHandler.okToSpawnAurora(world)) {
                    List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
                    for (EntityPlayerMP player : players) {
                        int preset;
                        int colorSet;
                        AuroraData aurora;
                        if (!BiomeRegistry.hasAurora(PlayerUtils.getPlayerBiome((EntityPlayer)player, false)) || ServerEffectHandler.isAuroraInRange(player, data) || !data.add(aurora = new AuroraData((EntityPlayer)player, -ModOptions.auroraSpawnOffset, colorSet = ColorPair.randomId(), preset = AuroraPreset.randomId()))) continue;
                        ModLog.debug("Spawned new aurora: " + aurora.toString(), new Object[0]);
                    }
                }
                for (AuroraData a : data) {
                    Network.sendAurora(a, world.field_73011_w.field_76574_g);
                }
            }
        }
    }
}

