/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModLog;

public final class ConfigProcessor {
    public static void process(Configuration config, Class<?> clazz) {
        ConfigProcessor.process(config, clazz, null);
    }

    public static void process(Configuration config, Class<?> clazz, Object parameters) {
        for (Field field : clazz.getFields()) {
            Parameter annotation = field.getAnnotation(Parameter.class);
            if (annotation == null) continue;
            String category = annotation.category();
            String property = annotation.property();
            String comment = field.getAnnotation(Comment.class) != null ? field.getAnnotation(Comment.class).value() : "";
            try {
                Object defaultValue = field.get(parameters);
                if (defaultValue instanceof Boolean) {
                    field.set(parameters, config.getBoolean(property, category, Boolean.valueOf(annotation.defaultValue()).booleanValue(), comment));
                } else if (defaultValue instanceof Integer) {
                    int minInt = Integer.MIN_VALUE;
                    int maxInt = Integer.MAX_VALUE;
                    MinMaxInt mmi = field.getAnnotation(MinMaxInt.class);
                    if (mmi != null) {
                        minInt = mmi.min();
                        maxInt = mmi.max();
                    }
                    field.set(parameters, config.getInt(property, category, Integer.valueOf(annotation.defaultValue()).intValue(), minInt, maxInt, comment));
                } else if (defaultValue instanceof Float) {
                    float minFloat = Float.MIN_VALUE;
                    float maxFloat = Float.MAX_VALUE;
                    MinMaxFloat mmf = field.getAnnotation(MinMaxFloat.class);
                    if (mmf != null) {
                        minFloat = mmf.min();
                        maxFloat = mmf.max();
                    }
                    field.set(parameters, Float.valueOf(config.getFloat(property, category, Float.valueOf(annotation.defaultValue()).floatValue(), minFloat, maxFloat, comment)));
                } else if (defaultValue instanceof String) {
                    field.set(parameters, config.getString(property, category, annotation.defaultValue(), comment));
                } else if (defaultValue instanceof String[]) {
                    field.set(parameters, config.getStringList(property, category, StringUtils.split((String)annotation.defaultValue(), (char)','), comment));
                }
                Property prop = config.getCategory(category).get(property);
                if (field.getAnnotation(RestartRequired.class) != null) {
                    RestartRequired restart = field.getAnnotation(RestartRequired.class);
                    prop.setRequiresMcRestart(restart.server());
                    prop.setRequiresWorldRestart(restart.world());
                } else {
                    prop.setRequiresMcRestart(false);
                    prop.setRequiresWorldRestart(false);
                }
                prop.setShowInGui(field.getAnnotation(Hidden.class) == null);
            }
            catch (Throwable t) {
                ModLog.error("Unable to parse configuration", t);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RestartRequired {
        public boolean world() default true;

        public boolean server() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface MinMaxFloat {
        public float min() default 1.4E-45f;

        public float max() default 3.4028235E38f;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface MinMaxInt {
        public int min() default -2147483648;

        public int max() default 0x7FFFFFFF;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public String value() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public String category();

        public String property();

        public String defaultValue();
    }
}

