/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.regex.Pattern;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;

public final class PlayerUtils {
    private static final int INSIDE_Y_ADJUST = 3;
    private static final Pattern REGEX_DEEP_OCEAN = Pattern.compile("(?i).*deep.*ocean.*|.*abyss.*");
    private static final Pattern REGEX_OCEAN = Pattern.compile("(?i)(?!.*deep.*)(.*ocean.*|.*kelp.*|.*coral.*)");
    private static final Pattern REGEX_RIVER = Pattern.compile("(?i).*river.*");
    private static final int RANGE = 3;
    private static final int AREA = 49;

    private PlayerUtils() {
    }

    public static BiomeGenBase getPlayerBiome(EntityPlayer player, boolean getTrue) {
        int theX = MathHelper.func_76128_c((double)player.field_70165_t);
        int theZ = MathHelper.func_76128_c((double)player.field_70161_v);
        BiomeGenBase biome = player.field_70170_p.func_72807_a(theX, theZ);
        if (!getTrue) {
            if (player.func_70055_a(Material.field_151586_h)) {
                biome = REGEX_RIVER.matcher(biome.field_76791_y).matches() ? BiomeRegistry.UNDERRIVER : (REGEX_OCEAN.matcher(biome.field_76791_y).matches() ? BiomeRegistry.UNDEROCEAN : (REGEX_DEEP_OCEAN.matcher(biome.field_76791_y).matches() ? BiomeRegistry.UNDERDEEPOCEAN : BiomeRegistry.UNDERWATER));
            } else {
                DimensionRegistry info = DimensionRegistry.getData(player.func_130014_f_());
                int theY = MathHelper.func_76128_c((double)player.field_70163_u);
                if (theY + 3 < info.getSeaLevel()) {
                    biome = BiomeRegistry.UNDERGROUND;
                } else if (theY >= info.getSpaceHeight()) {
                    biome = BiomeRegistry.OUTERSPACE;
                } else if (theY >= info.getCloudHeight()) {
                    biome = BiomeRegistry.CLOUDS;
                }
            }
        }
        return biome;
    }

    private static int getPlayerDimension(EntityPlayer player) {
        if (player == null || player.field_70170_p == null) {
            return -256;
        }
        return player.func_130014_f_().field_73011_w.field_76574_g;
    }

    private static float ceilingCoverageRatio(EntityPlayer entity) {
        World world = entity.func_130014_f_();
        int targetY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int baseX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int baseZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        int seeSky = 0;
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                int y = world.func_72825_h(baseX + x, baseZ + z);
                if (y - targetY >= 2) continue;
                ++seeSky;
            }
        }
        return 1.0f - (float)seeSky / 49.0f;
    }

    public static boolean isReallyInside(EntityPlayer entity) {
        return PlayerUtils.ceilingCoverageRatio(entity) > 0.42f;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getClientPlayerDimension() {
        return PlayerUtils.getPlayerDimension((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
    }
}

