/*
 * Decompiled with CFR 0.152.
 */
package emt;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import emt.command.CommandOutputs;
import emt.init.EMTEntities;
import emt.init.EMTResearches;
import emt.init.Registry;
import emt.network.PacketEMTKeys;
import emt.proxy.CommonProxy;
import emt.util.EMTClientEventHandler;
import emt.util.EMTConfigHandler;
import emt.util.EMTCreativeTab;
import emt.util.EMTDungeonChestGenerator;
import emt.util.EMTEssentiasOutputs;
import emt.util.EMTEventHandler;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="EMT", name="Electro-Magic Tools", version="1.2.6.2", guiFactory="emt.client.gui.config.EMTGuiFactory", dependencies="required-after:Thaumcraft ; required-after:IC2")
public class EMT {
    public static final String NAME = "Electro-Magic Tools";
    public static final String MOD_ID = "EMT";
    public static final String VERSION = "1.2.6.2";
    public static final String TEXTURE_PATH = "emt";
    public static final String GUI_FACTORY = "emt.client.gui.config.EMTGuiFactory";
    public static final String CLIENT_PROXY = "emt.proxy.ClientProxy";
    public static final String COMMON_PROXY = "emt.proxy.CommonProxy";
    public static final String CHANNEL = "EMT";
    public static final String DEPENDS = "required-after:Thaumcraft ; required-after:IC2";
    @SidedProxy(clientSide="emt.proxy.ClientProxy", serverSide="emt.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs TAB;
    public static final Logger LOGGER;
    public static final SimpleNetworkWrapper INSTANCE;
    @Mod.Instance(value="EMT")
    public static EMT instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Starting planning the world domination");
        EMTConfigHandler.init(event.getSuggestedConfigurationFile());
        FMLCommonHandler.instance().bus().register((Object)new EMTEventHandler());
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLCommonHandler.instance().bus().register((Object)new EMTClientEventHandler());
        }
        Registry.register();
        EMTEssentiasOutputs.addPrimalOutputs();
        EMTEssentiasOutputs.addOutputs();
        this.registerPackets();
        LOGGER.info("Planning complete");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        LOGGER.info("Gathering allies");
        LOGGER.info("Loading the proxies");
        proxy.load();
        LOGGER.info("Making mobs drop additional items");
        MinecraftForge.EVENT_BUS.register((Object)new EMTEventHandler());
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new EMTClientEventHandler());
        }
        LOGGER.info("Adding dungeon loot");
        EMTDungeonChestGenerator.generateLoot();
        LOGGER.info("Registering entities");
        EMTEntities.registerEMTEntities();
        LOGGER.info("Registering the GUI Handler");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        LOGGER.info("Allies gathered.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.info("Starting the world takeover");
        Registry.registerLate();
        EMTResearches.register();
        LOGGER.info("World takeover complete. Enjoy!");
    }

    @Mod.EventHandler
    public void onFMLServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandOutputs());
    }

    public void registerPackets() {
        INSTANCE.registerMessage(PacketEMTKeys.class, PacketEMTKeys.class, 0, Side.SERVER);
    }

    static {
        TAB = new EMTCreativeTab("EMT.creativeTab");
        LOGGER = LogManager.getLogger((String)NAME);
        INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("EMT");
    }
}

