/*
 * Decompiled with CFR 0.152.
 */
package emt.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.EMT;
import emt.tile.TileEntityEMT;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockBaseContainer
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    IconSet[] iconSets;
    public int instance;
    public int countOfMetas;

    public BlockBaseContainer(String unlocName, Material material, Block.SoundType soundType, float hardness) {
        this(unlocName, material, soundType, 1, hardness);
    }

    public BlockBaseContainer(String unlocName, Material material, Block.SoundType soundType, int countOfMetas, float hardness) {
        this(unlocName, material, soundType, countOfMetas, 0, hardness);
    }

    public BlockBaseContainer(String unlocName, Material material, Block.SoundType soundType, int countOfMetas, int curInstance, float hardness) {
        super(material);
        this.func_149663_c("EMT." + unlocName);
        this.func_149647_a(EMT.TAB);
        this.func_149672_a(soundType);
        this.func_149711_c(hardness);
        this.countOfMetas = countOfMetas;
        this.instance = curInstance;
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.iconSets = new IconSet[countOfMetas];
            for (int meta = 0; meta < countOfMetas; ++meta) {
                this.iconSets[meta] = new IconSet();
            }
        }
    }

    public IconSet[] getIconSets() {
        return this.iconSets;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        TileEntityEMT tile = (TileEntityEMT)access.func_147438_o(x, y, z);
        int meta = access.func_72805_g(x, y, z);
        IconSet set = this.iconSets[meta];
        if (side == 0) {
            return set.bottom;
        }
        if (side == 1) {
            return set.top;
        }
        if (side != tile.facing) {
            return set.side;
        }
        if (tile.isOn) {
            if (set.frontOn != null) {
                return set.frontOn;
            }
            if (set.frontOff != null) {
                return set.frontOff;
            }
            return set.side;
        }
        if (set.frontOff != null) {
            return set.frontOff;
        }
        return set.side;
    }

    public IIcon func_149691_a(int side, int meta) {
        IconSet set = this.iconSets[meta];
        if (side < 1) {
            return set.bottom;
        }
        if (side == 1) {
            return set.top;
        }
        if (side == 3) {
            return set.frontOff;
        }
        return set.side;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        int facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityEMT tile = (TileEntityEMT)world.func_147438_o(x, y, z);
        switch (facing) {
            case 0: {
                tile.facing = 2;
                break;
            }
            case 1: {
                tile.facing = 5;
                break;
            }
            case 2: {
                tile.facing = 3;
                break;
            }
            case 3: {
                tile.facing = 4;
            }
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public static class IconSet {
        public IIcon top;
        public IIcon bottom;
        public IIcon side;
        public IIcon frontOff;
        public IIcon frontOn;
    }
}

