/*
 * Decompiled with CFR 0.152.
 */
package emt.item.armor.goggles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.EMT;
import emt.item.armor.goggles.ItemQuantumGoggles;
import emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemSolarHelmetRevealing
extends ItemQuantumGoggles {
    private int ticker;
    private int generating;
    private int genDay;
    private int genNight;
    private boolean sunIsUp;
    private boolean skyIsVisible;
    private boolean noSunWorld;
    private boolean dampPlace;
    private static final Map potionCost = new HashMap();

    public ItemSolarHelmetRevealing(ItemArmor.ArmorMaterial material, int par3, int par4) {
        super(material, par3, par4);
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77637_a(EMT.TAB);
        this.maxCharge = 1000000.0;
        this.genDay = 256;
        this.genNight = 128;
        this.maxCharge = 1.0E7;
        this.visDiscount = 7;
        this.tier = 3;
        this.transferLimit = 10000.0;
        this.energyPerDamage = 10000;
        potionCost.put(Potion.field_76436_u.field_76415_H, 10000);
        potionCost.put(Potion.field_82731_v.field_76415_H, 15000);
        potionCost.put(Potion.field_76431_k.field_76415_H, 5000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("emt:armor/goggles_solar");
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layerType) {
        return "emt:textures/models/solarrevealinghelmet.png";
    }

    @Override
    public void onArmorTick(World worldObj, EntityPlayer player, ItemStack itemStack) {
        if (!EMTConfigHandler.nightVisionOff) {
            if (ElectricItem.manager.canUse(itemStack, 0.0)) {
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                int y = MathHelper.func_76128_c((double)player.field_70163_u);
                int lightlevel = player.field_70170_p.func_72957_l(x, y, z);
                if (lightlevel >= 0) {
                    player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, -3));
                }
                ElectricItem.manager.use(itemStack, 0.0, (EntityLivingBase)player);
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 300, 0, true));
            }
        }
        int refill = player.func_70086_ai();
        if (ElectricItem.manager.canUse(itemStack, 1000.0) && refill < 100) {
            player.func_70050_g(refill + 200);
            ElectricItem.manager.use(itemStack, 1000.0, null);
        }
        for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
            int id = effect.func_76456_a();
            Integer cost = (Integer)potionCost.get(id);
            if (cost == null || !ElectricItem.manager.canUse(itemStack, (double)(cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
            ElectricItem.manager.use(itemStack, (double)cost.intValue(), null);
            ItemStack milk = new ItemStack(Items.field_151117_aB);
            player.curePotionEffects(milk);
        }
        if (worldObj.field_72995_K) {
            return;
        }
        this.checkForSun(player);
        if (this.generating > 0) {
            int energyLeft = this.generating;
            for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                if (energyLeft > 0) {
                    if (player.field_71071_by.field_70460_b[i] == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IElectricItem)) continue;
                    double sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70460_b[i], (double)energyLeft, 4, false, false);
                    energyLeft = (int)((double)energyLeft - sentPacket);
                    continue;
                }
                return;
            }
            for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
                if (energyLeft > 0) {
                    if (player.field_71071_by.field_70462_a[j] == null || !(player.field_71071_by.field_70462_a[j].func_77973_b() instanceof IElectricItem)) continue;
                    double sentPacket = ElectricItem.manager.charge(player.field_71071_by.field_70462_a[j], (double)energyLeft, 4, false, false);
                    energyLeft = (int)((double)energyLeft - sentPacket);
                    continue;
                }
                return;
            }
        }
    }

    public int checkForSun(EntityPlayer player) {
        if (this.ticker++ % ItemSolarHelmetRevealing.tickRate() == 0) {
            this.updateVisibility(player);
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.generating = 0 + this.genDay;
            return this.generating;
        }
        if (this.skyIsVisible) {
            this.generating = 0 + this.genNight;
            return this.generating;
        }
        this.generating = 0;
        return this.generating;
    }

    public void updateVisibility(EntityPlayer player) {
        this.dampPlace = player.field_70170_p.func_72959_q().func_76935_a((int)player.field_70165_t, (int)player.field_70161_v).func_76744_g() > 0;
        this.noSunWorld = player.field_70170_p.field_73011_w.field_76576_e;
        Boolean rainWeather = this.dampPlace && (player.field_70170_p.func_72896_J() || player.field_70170_p.func_72911_I());
        this.sunIsUp = player.field_70170_p.func_72935_r() && rainWeather == false;
        this.skyIsVisible = player.field_70170_p.func_72937_j((int)player.field_70165_t, (int)player.field_70163_u + 1, (int)player.field_70161_v) && !this.noSunWorld;
    }

    public static int tickRate() {
        return 128;
    }
}

