/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.common.config.ConfigProcessor;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class PacketConfigSync
implements IMessage {
    private Map<String, Object> configValues;
    private String modid;
    private static final Set<String> allowed = Sets.newHashSet((Object[])new String[]{Character.class.getName(), Number.class.getName(), Float.class.getName(), Double.class.getName(), Integer.class.getName(), HashMap.class.getName(), Map.class.getName(), Boolean.class.getName(), Byte.class.getName(), String.class.getName(), Enum.class.getName(), Long.class.getName(), Short.class.getName()});

    public PacketConfigSync() {
    }

    public PacketConfigSync(ConfigProcessor toSync) {
        this.configValues = toSync.configValues;
        this.modid = toSync.modid;
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            ObjectOutputStream objStream = new ObjectOutputStream(gzip);
            objStream.writeObject(this.configValues);
            objStream.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        buf.writeShort(obj.size());
        buf.writeBytes(obj.toByteArray());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modid);
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        byte[] compressedBody = new byte[len];
        for (short i = 0; i < len; i = (short)(i + 1)) {
            compressedBody[i] = buf.readByte();
        }
        try {
            ObjectInputStream obj = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(compressedBody))){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass obj) throws IOException, ClassNotFoundException {
                    String name = obj.getName();
                    if (!allowed.contains(name)) {
                        throw new RuntimeException("[EnderIO] Try to decode invalid value, may be hack? (" + name + ")");
                    }
                    return super.resolveClass(obj);
                }
            };
            this.configValues = (Map)obj.readObject();
            obj.close();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        this.modid = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketConfigSync, PacketConfigSync> {
        public PacketConfigSync onMessage(PacketConfigSync message, MessageContext ctx) {
            ConfigProcessor processor = ConfigProcessor.processorMap.get(message.modid);
            if (processor != null) {
                processor.syncTo(message.configValues);
            }
            return null;
        }
    }
}

