/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import net.minecraft.util.EnumChatFormatting;

public enum IoMode {
    NONE("gui.machine.ioMode.none"),
    PULL("gui.machine.ioMode.pull"),
    PUSH("gui.machine.ioMode.push"),
    PUSH_PULL("gui.machine.ioMode.pullPush"),
    DISABLED("gui.machine.ioMode.disabled");

    private final String unlocalisedName;
    public static final IoMode[] MODES;

    private IoMode(String unlocalisedName) {
        this.unlocalisedName = unlocalisedName;
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public static ConnectionMode getNext(ConnectionMode mode) {
        int ord = mode.ordinal() + 1;
        if (ord >= ConnectionMode.MODES.length) {
            ord = 0;
        }
        return ConnectionMode.MODES[ord];
    }

    public static ConnectionMode getPrevious(ConnectionMode mode) {
        int ord = mode.ordinal() - 1;
        if (ord < 0) {
            ord = ConnectionMode.MODES.length - 1;
        }
        return ConnectionMode.MODES[ord];
    }

    public boolean pulls() {
        return this == PULL || this == PUSH_PULL;
    }

    public boolean pushes() {
        return this == PUSH || this == PUSH_PULL;
    }

    public boolean canOutput() {
        return this.pushes() || this == NONE;
    }

    public boolean canRecieveInput() {
        return this.pulls() || this == NONE;
    }

    public String getLocalisedName() {
        return EnderIO.lang.localize(this.unlocalisedName);
    }

    public String colorLocalisedName() {
        String loc = this.getLocalisedName();
        switch (this) {
            case DISABLED: {
                return EnumChatFormatting.RED + loc;
            }
            case NONE: {
                return EnumChatFormatting.GRAY + loc;
            }
            case PULL: {
                return EnumChatFormatting.AQUA + loc;
            }
            case PUSH: {
                return EnumChatFormatting.GOLD + loc;
            }
            case PUSH_PULL: {
                return String.format(EnderIO.lang.localize(this.getUnlocalisedName() + ".colored"), EnumChatFormatting.GOLD, EnumChatFormatting.WHITE, EnumChatFormatting.AQUA);
            }
        }
        return loc;
    }

    public IoMode next() {
        int index = this.ordinal() + 1;
        if (index >= MODES.length) {
            index = 0;
        }
        return MODES[index];
    }

    static {
        MODES = IoMode.values();
    }
}

