/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.CompressedDataOutput;
import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.network.NetworkUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.invpanel.PacketItemInfo;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import crazypants.enderio.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketRequestMissingItems
extends MessageTileEntity<TileInventoryPanel>
implements IMessageHandler<PacketRequestMissingItems, IMessage> {
    private byte[] compressed;

    public PacketRequestMissingItems() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketRequestMissingItems(TileInventoryPanel tile, int generation, List<Integer> missingIDs) {
        super((TileEntity)tile);
        try (CompressedDataOutput cdo = new CompressedDataOutput();){
            cdo.writeVariable(generation);
            cdo.writeVariable(missingIDs.size());
            for (Integer id : missingIDs) {
                cdo.writeVariable(id - 65536);
            }
            this.compressed = cdo.getCompressed();
        }
        catch (IOException ex) {
            this.compressed = new byte[0];
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.compressed = NetworkUtil.readByteArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.compressed);
    }

    public IMessage onMessage(PacketRequestMissingItems message, MessageContext ctx) {
        TileInventoryPanel teInvPanel;
        InventoryDatabaseServer db;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileEntity te = player.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (te instanceof TileInventoryPanel && (db = (teInvPanel = (TileInventoryPanel)te).getDatabaseServer()) != null) {
            try {
                List<ItemEntry> items = db.decompressMissingItems(message.compressed);
                if (!items.isEmpty()) {
                    PacketHandler.sendTo((IMessage)new PacketItemInfo(teInvPanel, db, items), player);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while reading missing item IDs", ex);
            }
        }
        return null;
    }

    protected boolean isValidTile(TileEntity tile) {
        return tile instanceof TileInventoryPanel;
    }
}

