/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.common.network.MessageTileEntity;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.vacuum.TileVacuumChest;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketVaccumChest
extends MessageTileEntity<TileVacuumChest>
implements IMessageHandler<PacketVaccumChest, IMessage> {
    public static final int CMD_SET_RANGE = 0;
    public static final int CMD_SET_SLOT = 1;
    public static final int CMD_SET_BLACKLIST = 2;
    public static final int CMD_SET_MATCHMETA = 3;
    private int cmd;
    private int value;
    private ItemStack stack;

    public PacketVaccumChest() {
    }

    private PacketVaccumChest(TileVacuumChest tile, int cmd) {
        super((TileEntity)tile);
        this.cmd = cmd;
    }

    public static PacketVaccumChest setRange(TileVacuumChest tile, int range) {
        PacketVaccumChest msg = new PacketVaccumChest(tile, 0);
        msg.value = range;
        tile.setRange(range);
        return msg;
    }

    public static PacketVaccumChest setFilterSlot(TileVacuumChest tile, int slot, ItemStack stack) {
        PacketVaccumChest msg = new PacketVaccumChest(tile, 1);
        msg.value = slot;
        msg.stack = stack;
        tile.setItemFilterSlot(slot, stack);
        return msg;
    }

    public static PacketVaccumChest setFilterBlacklist(TileVacuumChest tile, boolean isBlacklist) {
        PacketVaccumChest msg = new PacketVaccumChest(tile, 2);
        msg.value = isBlacklist ? 1 : 0;
        tile.setFilterBlacklist(isBlacklist);
        return msg;
    }

    public static PacketVaccumChest setFilterMatchMeta(TileVacuumChest tile, boolean matchMeta) {
        PacketVaccumChest msg = new PacketVaccumChest(tile, 3);
        msg.value = matchMeta ? 1 : 0;
        tile.setFilterMatchMeta(matchMeta);
        return msg;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.cmd = buf.readByte() & 0xFF;
        this.value = buf.readInt();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.cmd);
        buf.writeInt(this.value);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public IMessage onMessage(PacketVaccumChest msg, MessageContext ctx) {
        TileVacuumChest te = (TileVacuumChest)msg.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
        if (te != null) {
            switch (msg.cmd) {
                case 0: {
                    te.setRange(msg.value);
                    break;
                }
                case 1: {
                    te.setItemFilterSlot(msg.value, msg.stack);
                    break;
                }
                case 2: {
                    te.setFilterBlacklist(msg.value != 0);
                    break;
                }
                case 3: {
                    te.setFilterMatchMeta(msg.value != 0);
                }
            }
        }
        return null;
    }

    protected boolean isValidTile(TileEntity tile) {
        return tile instanceof TileVacuumChest;
    }
}

